/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.validation;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;

@ApplicationScoped
public class ClientValidationService {
    private Caller<ValidationService> validationService;

    @Inject
    public ClientValidationService(Caller<ValidationService> validationService) {
        this.validationService = validationService;
    }

    public void isValidGroupId(String groupId, final ValidatorCallback callback) {
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean result) {
                if (Boolean.TRUE.equals(result)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure();
                }
            }
        })).validateGroupId(groupId);
    }

    public void isValidArtifactId(String artifactId, final ValidatorCallback callback) {
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean result) {
                if (Boolean.TRUE.equals(result)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure();
                }
            }
        })).validateArtifactId(artifactId);
    }

    public void isValidVersionId(String versionId, final ValidatorCallback callback) {
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean result) {
                if (Boolean.TRUE.equals(result)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure();
                }
            }
        })).validateGAVVersion(versionId);
    }

    public void isValidClassName(String className, final ValidatorCallback callback) {
        String[] identifiers = className.split("\\.", -1);
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Map<String, Boolean>>(){

            public void callback(Map<String, Boolean> results) {
                Boolean result = false;
                for (Boolean subResult : results.values()) {
                    if (Boolean.FALSE.equals(subResult)) {
                        result = false;
                        break;
                    }
                    result = true;
                }
                if (result.booleanValue()) {
                    callback.onSuccess();
                } else {
                    callback.onFailure();
                }
            }
        })).evaluateJavaIdentifiers(identifiers);
    }

    public void isValidDriverName(String driverName, ValidatorCallback callback) {
        this.isNotEmpty(driverName, callback);
    }

    public void isValidDataSourceName(String dataSourceName, ValidatorCallback callback) {
        this.isNotEmpty(dataSourceName, callback);
    }

    public void isValidConnectionURL(String connectionURL, ValidatorCallback callback) {
        this.isNotEmpty(connectionURL, callback);
    }

    public void isNotEmpty(String value, ValidatorCallback callback) {
        if (!this.isEmpty(value)) {
            callback.onSuccess();
        } else {
            callback.onFailure();
        }
    }

    public boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }
}

