/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.driver;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.editor.driver.DriverDefMainPanel;
import org.kie.workbench.common.screens.datasource.management.client.editor.driver.DriverDefMainPanelView;
import org.kie.workbench.common.screens.datasource.management.client.validation.ClientValidationService;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;

@Dependent
public class DriverDefEditorHelper {
    private TranslationService translationService;
    private DriverDef driverDef;
    private DriverDefMainPanel mainPanel;
    private DriverDefMainPanelView.Handler handler;
    private ClientValidationService validationService;
    private boolean nameValid = false;
    private boolean driverClassValid = false;
    private boolean groupIdValid = false;
    private boolean artifactIdValid = false;
    private boolean versionValid = false;

    @Inject
    public DriverDefEditorHelper(TranslationService translationService, ClientValidationService validationService) {
        this.translationService = translationService;
        this.validationService = validationService;
    }

    public void init(DriverDefMainPanel mainPanel) {
        this.mainPanel = mainPanel;
        mainPanel.setHandler(new DriverDefMainPanelView.Handler(){

            @Override
            public void onNameChange() {
                DriverDefEditorHelper.this.onNameChange();
            }

            @Override
            public void onDriverClassChange() {
                DriverDefEditorHelper.this.onDriverClassChange();
            }

            @Override
            public void onGroupIdChange() {
                DriverDefEditorHelper.this.onGroupIdChange();
            }

            @Override
            public void onArtifactIdChange() {
                DriverDefEditorHelper.this.onArtifactIdChange();
            }

            @Override
            public void onVersionChange() {
                DriverDefEditorHelper.this.onVersionIdChange();
            }
        });
    }

    public void setHandler(DriverDefMainPanelView.Handler handler) {
        this.handler = handler;
    }

    public void onNameChange() {
        final String newValue = this.mainPanel.getName().trim();
        this.validationService.isValidDriverName(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DriverDefEditorHelper.this.onNameChange(newValue, true);
            }

            public void onFailure() {
                DriverDefEditorHelper.this.onNameChange(newValue, false);
            }
        });
    }

    private void onNameChange(String newValue, boolean isValid) {
        this.driverDef.setName(newValue);
        this.nameValid = isValid;
        if (!this.nameValid) {
            this.mainPanel.setNameErrorMessage(this.getMessage("DriverDefEditor.InvalidNameMessage"));
        } else {
            this.mainPanel.clearNameErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onNameChange();
        }
    }

    public void onDriverClassChange() {
        final String newValue = this.mainPanel.getDriverClass().trim();
        this.validationService.isValidClassName(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DriverDefEditorHelper.this.onDriverClassChange(newValue, true);
            }

            public void onFailure() {
                DriverDefEditorHelper.this.onDriverClassChange(newValue, false);
            }
        });
    }

    private void onDriverClassChange(String newValue, boolean isValid) {
        this.driverDef.setDriverClass(newValue);
        this.driverClassValid = isValid;
        if (!this.driverClassValid) {
            this.mainPanel.setDriverClassErrorMessage(this.getMessage("DriverDefEditor.InvalidDriverClassMessage"));
        } else {
            this.mainPanel.clearDriverClassErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onDriverClassChange();
        }
    }

    public void onGroupIdChange() {
        final String newValue = this.mainPanel.getGroupId().trim();
        this.validationService.isValidGroupId(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DriverDefEditorHelper.this.onGroupIdChange(newValue, true);
            }

            public void onFailure() {
                DriverDefEditorHelper.this.onGroupIdChange(newValue, false);
            }
        });
    }

    private void onGroupIdChange(String newValue, boolean isValid) {
        this.driverDef.setGroupId(newValue);
        this.groupIdValid = isValid;
        if (!this.groupIdValid) {
            this.mainPanel.setGroupIdErrorMessage(this.getMessage("DriverDefEditor.InvalidGroupIdMessage"));
        } else {
            this.mainPanel.clearGroupIdErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onGroupIdChange();
        }
    }

    public void onArtifactIdChange() {
        final String newValue = this.mainPanel.getArtifactId().trim();
        this.validationService.isValidArtifactId(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DriverDefEditorHelper.this.onArtifactIdChange(newValue, true);
            }

            public void onFailure() {
                DriverDefEditorHelper.this.onArtifactIdChange(newValue, false);
            }
        });
    }

    private void onArtifactIdChange(String newValue, boolean isValid) {
        this.driverDef.setArtifactId(newValue);
        this.artifactIdValid = isValid;
        if (!this.artifactIdValid) {
            this.mainPanel.setArtifactIdErrorMessage(this.getMessage("DriverDefEditor.InvalidArtifactIdMessage"));
        } else {
            this.mainPanel.clearArtifactIdErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onArtifactIdChange();
        }
    }

    public void onVersionIdChange() {
        final String newValue = this.mainPanel.getVersion().trim();
        this.validationService.isValidVersionId(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DriverDefEditorHelper.this.onVersionIdChange(newValue, true);
            }

            public void onFailure() {
                DriverDefEditorHelper.this.onVersionIdChange(newValue, false);
            }
        });
    }

    private void onVersionIdChange(String newValue, boolean isValid) {
        this.driverDef.setVersion(newValue);
        this.versionValid = isValid;
        if (!this.versionValid) {
            this.mainPanel.setVersionErrorMessage(this.getMessage("DriverDefEditor.InvalidVersionMessage"));
        } else {
            this.mainPanel.clearVersionErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onVersionChange();
        }
    }

    public boolean isNameValid() {
        return this.nameValid;
    }

    public boolean isDriverClassValid() {
        return this.driverClassValid;
    }

    public boolean isGroupIdValid() {
        return this.groupIdValid;
    }

    public boolean isArtifactIdValid() {
        return this.artifactIdValid;
    }

    public boolean isVersionValid() {
        return this.versionValid;
    }

    public void setValid(boolean valid) {
        this.nameValid = valid;
        this.driverClassValid = valid;
        this.groupIdValid = valid;
        this.artifactIdValid = valid;
        this.versionValid = valid;
    }

    public void setDriverDef(DriverDef driverDef) {
        this.driverDef = driverDef;
        this.mainPanel.clear();
        this.mainPanel.setName(driverDef.getName());
        this.mainPanel.setDriverClass(driverDef.getDriverClass());
        this.mainPanel.setGroupId(driverDef.getGroupId());
        this.mainPanel.setArtifactId(driverDef.getArtifactId());
        this.mainPanel.setVersion(driverDef.getVersion());
    }

    public String getMessage(String messageKey) {
        return this.translationService.getTranslation(messageKey);
    }

    public String getMessage(String messageKey, Object ... args) {
        return this.translationService.format(messageKey, args);
    }
}

