/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.wizard.driver;

import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.screens.datasource.management.client.editor.driver.DriverDefEditorHelper;
import org.kie.workbench.common.screens.datasource.management.client.editor.driver.DriverDefMainPanel;
import org.kie.workbench.common.screens.datasource.management.client.editor.driver.DriverDefMainPanelView;
import org.kie.workbench.common.screens.datasource.management.client.wizard.driver.DriverDefPageView;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class DriverDefPage
implements WizardPage,
DriverDefPageView.Presenter {
    private DriverDefPageView view;
    private DriverDefMainPanel mainPanel;
    private DriverDefEditorHelper editorHelper;
    private Event<WizardPageStatusChangeEvent> statusChangeEvent;

    @Inject
    public DriverDefPage(DriverDefPageView view, DriverDefMainPanel mainPanel, DriverDefEditorHelper editorHelper, Event<WizardPageStatusChangeEvent> statusChangeEvent) {
        this.view = view;
        this.mainPanel = mainPanel;
        this.editorHelper = editorHelper;
        this.statusChangeEvent = statusChangeEvent;
        view.init(this);
        editorHelper.init(mainPanel);
        editorHelper.setHandler(new DriverDefMainPanelView.Handler(){

            @Override
            public void onNameChange() {
                DriverDefPage.this.notifyChange();
            }

            @Override
            public void onDriverClassChange() {
                DriverDefPage.this.notifyChange();
            }

            @Override
            public void onGroupIdChange() {
                DriverDefPage.this.notifyChange();
            }

            @Override
            public void onArtifactIdChange() {
                DriverDefPage.this.notifyChange();
            }

            @Override
            public void onVersionChange() {
                DriverDefPage.this.notifyChange();
            }
        });
    }

    @PostConstruct
    private void init() {
        this.view.setMainPanel(this.mainPanel);
    }

    public void setDriverDef(DriverDef driverDef) {
        this.editorHelper.setDriverDef(driverDef);
    }

    public String getTitle() {
        return this.view.getPageTitle();
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean complete = this.editorHelper.isNameValid() && this.editorHelper.isDriverClassValid() && this.editorHelper.isGroupIdValid() && this.editorHelper.isArtifactIdValid() && this.editorHelper.isVersionValid();
        callback.callback((Object)complete);
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public void notifyChange() {
        WizardPageStatusChangeEvent event = new WizardPageStatusChangeEvent((WizardPage)this);
        this.statusChangeEvent.fire((Object)event);
    }

    public void setComplete(boolean complete) {
        this.editorHelper.setValid(complete);
    }

    public void clear() {
        this.mainPanel.clear();
    }
}

