/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.wizard.driver;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.util.PopupsUtil;
import org.kie.workbench.common.screens.datasource.management.client.wizard.driver.DriverDefPage;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.service.DriverDefEditorService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewDriverDefWizard
extends AbstractWizard {
    private final List<WizardPage> pages = new ArrayList<WizardPage>();
    private DriverDefPage driverDefPage;
    private DriverDef driverDef;
    private Caller<DriverDefEditorService> driverDefService;
    private TranslationService translationService;
    private PopupsUtil popupsUtil;
    private Event<NotificationEvent> notification;
    private Module module;

    @Inject
    public NewDriverDefWizard(DriverDefPage driverDefPage, Caller<DriverDefEditorService> driverDefService, TranslationService translationService, PopupsUtil popupsUtil, Event<NotificationEvent> notification) {
        this.driverDefPage = driverDefPage;
        this.driverDefService = driverDefService;
        this.translationService = translationService;
        this.popupsUtil = popupsUtil;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.pages.add(this.driverDefPage);
    }

    public void start() {
        this.driverDefPage.clear();
        this.driverDefPage.setComplete(false);
        this.driverDef = new DriverDef();
        this.driverDefPage.setDriverDef(this.driverDef);
        super.start();
    }

    public List<WizardPage> getPages() {
        return this.pages;
    }

    public Widget getPageWidget(int pageNumber) {
        return this.pages.get(pageNumber).asWidget();
    }

    public String getTitle() {
        return this.translationService.getTranslation("NewDriverDefWizard.title");
    }

    public int getPreferredHeight() {
        return 600;
    }

    public int getPreferredWidth() {
        return 700;
    }

    public void isComplete(Callback<Boolean> callback) {
        this.driverDefPage.isComplete(callback);
    }

    public void complete() {
        this.doComplete();
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void setGlobal() {
        this.module = null;
    }

    private void doComplete() {
        if (this.isGlobal()) {
            ((DriverDefEditorService)this.driverDefService.call(this.getCreateSuccessCallback(), this.getCreateErrorCallback())).createGlobal(this.driverDef);
        } else {
            ((DriverDefEditorService)this.driverDefService.call(this.getCreateSuccessCallback(), this.getCreateErrorCallback())).create(this.driverDef, this.module);
        }
    }

    private RemoteCallback<Path> getCreateSuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                NewDriverDefWizard.this.notification.fire((Object)new NotificationEvent(NewDriverDefWizard.this.translationService.format("NewDriverDefWizard.DriverCreatedMessage", new Object[]{path.toString()})));
                NewDriverDefWizard.super.complete();
            }
        };
    }

    private ErrorCallback<?> getCreateErrorCallback() {
        return (message, throwable) -> {
            this.popupsUtil.showErrorPopup(this.translationService.format("NewDriverDefWizard.DriverCreateErrorMessage", new Object[]{this.buildOnCreateErrorMessage(throwable)}));
            return false;
        };
    }

    private String buildOnCreateErrorMessage(Throwable t) {
        if (t instanceof FileAlreadyExistsException) {
            return this.translationService.format("NewDataSourceDefWizard.FileExistsErrorMessage", new Object[]{((FileAlreadyExistsException)t).getFile()});
        }
        return t.getMessage();
    }

    private boolean isGlobal() {
        return this.module == null;
    }
}

