/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.wizard.datasource;

import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefEditorHelper;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanel;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanelView;
import org.kie.workbench.common.screens.datasource.management.client.wizard.datasource.DataSourceDefPageView;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class DataSourceDefPage
implements WizardPage,
DataSourceDefPageView.Presenter {
    private DataSourceDefPageView view;
    private DataSourceDefMainPanel mainPanel;
    private DataSourceDefEditorHelper editorHelper;
    private Event<WizardPageStatusChangeEvent> statusChangeEvent;

    @Inject
    public DataSourceDefPage(DataSourceDefPageView view, DataSourceDefMainPanel mainPanel, DataSourceDefEditorHelper editorHelper, Event<WizardPageStatusChangeEvent> statusChangeEvent) {
        this.view = view;
        this.mainPanel = mainPanel;
        this.editorHelper = editorHelper;
        this.statusChangeEvent = statusChangeEvent;
        view.init(this);
        editorHelper.init(mainPanel);
        editorHelper.setHandler(new DataSourceDefMainPanelView.Handler(){

            @Override
            public void onNameChange() {
                DataSourceDefPage.this.notifyChange();
            }

            @Override
            public void onConnectionURLChange() {
                DataSourceDefPage.this.notifyChange();
            }

            @Override
            public void onUserChange() {
                DataSourceDefPage.this.notifyChange();
            }

            @Override
            public void onPasswordChange() {
                DataSourceDefPage.this.notifyChange();
            }

            @Override
            public void onDriverChange() {
                DataSourceDefPage.this.notifyChange();
            }

            @Override
            public void onTestConnection() {
            }
        });
    }

    @PostConstruct
    private void init() {
        this.view.setMainPanel(this.mainPanel);
    }

    public void setDataSourceDef(DataSourceDef dataSourceDef) {
        this.editorHelper.setDataSourceDef(dataSourceDef);
    }

    public void setModule(Module module) {
        this.editorHelper.setModule(module);
    }

    public String getTitle() {
        return this.view.getPageTitle();
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean complete = this.editorHelper.isNameValid() && this.editorHelper.isConnectionURLValid() && this.editorHelper.isUserValid() && this.editorHelper.isPasswordValid() && this.editorHelper.isDriverValid();
        callback.callback((Object)complete);
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public void loadDrivers(Command onSuccessCommand, ParameterizedCommand<Throwable> onFailureCommand) {
        this.editorHelper.loadDrivers(onSuccessCommand, onFailureCommand);
    }

    public void notifyChange() {
        WizardPageStatusChangeEvent event = new WizardPageStatusChangeEvent((WizardPage)this);
        this.statusChangeEvent.fire((Object)event);
    }

    public void setComplete(boolean complete) {
        this.editorHelper.setValid(complete);
    }

    public void clear() {
        this.mainPanel.clear();
    }
}

