/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas.DatabaseSchemaExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas.DatabaseSchemaRow;
import org.kie.workbench.common.screens.datasource.management.client.util.InitializeCallback;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.SchemaMetadata;
import org.kie.workbench.common.screens.datasource.management.service.DatabaseMetadataService;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;

@Dependent
public class DatabaseSchemaExplorer
implements DatabaseSchemaExplorerView.Presenter,
IsElement {
    private DatabaseSchemaExplorerView view;
    private Caller<DatabaseMetadataService> metadataService;
    private AsyncDataProvider<DatabaseSchemaRow> dataProvider;
    private TranslationService translationService;
    private List<DatabaseSchemaRow> rows = new ArrayList<DatabaseSchemaRow>();
    private Settings settings;
    private DatabaseSchemaExplorerView.Handler handler;

    public DatabaseSchemaExplorer() {
    }

    @Inject
    public DatabaseSchemaExplorer(DatabaseSchemaExplorerView view, Caller<DatabaseMetadataService> metadataService, TranslationService translationService) {
        this.view = view;
        view.init(this);
        this.metadataService = metadataService;
        this.translationService = translationService;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @PostConstruct
    protected void init() {
        this.dataProvider = new AsyncDataProvider<DatabaseSchemaRow>(){

            protected void onRangeChanged(HasData<DatabaseSchemaRow> display) {
                this.updateRowCount(DatabaseSchemaExplorer.this.rows.size(), true);
                this.updateRowData(0, DatabaseSchemaExplorer.this.rows);
            }
        };
        this.view.setDataProvider(this.dataProvider);
    }

    public void initialize(Settings settings) {
        this.initialize(settings, null);
    }

    public void initialize(Settings settings, InitializeCallback initializeCallback) {
        this.settings = settings;
        this.loadSchemas(settings.dataSourceUuid(), initializeCallback);
    }

    public void addHandler(DatabaseSchemaExplorerView.Handler handler) {
        this.handler = handler;
    }

    @Override
    public void onOpen(DatabaseSchemaRow row) {
        if (this.handler != null) {
            this.handler.onOpen(row.getName());
        }
    }

    public boolean hasItems() {
        return !this.rows.isEmpty();
    }

    protected List<DatabaseSchemaRow> getItems() {
        return this.rows;
    }

    private void loadSchemas(String dataSourceUuid, final InitializeCallback initializeCallback) {
        this.clear();
        this.view.showBusyIndicator(this.translationService.getTranslation("DatabaseSchemaExplorerViewImpl.loadingDbSchemas"));
        ((DatabaseMetadataService)this.metadataService.call((RemoteCallback)new RemoteCallback<DatabaseMetadata>(){

            public void callback(DatabaseMetadata metadata) {
                DatabaseSchemaExplorer.this.view.hideBusyIndicator();
                DatabaseSchemaExplorer.this.loadSchemas(metadata.getSchemas());
                if (initializeCallback != null) {
                    initializeCallback.onInitializeSuccess();
                }
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback(this.view){

            public boolean error(Message message, Throwable throwable) {
                boolean result = super.error(message, throwable);
                if (initializeCallback != null) {
                    initializeCallback.onInitializeError(throwable);
                }
                return result;
            }
        })).getMetadata(dataSourceUuid, false, true);
    }

    private void loadSchemas(List<SchemaMetadata> schemas) {
        for (SchemaMetadata metadata : schemas) {
            this.rows.add(new DatabaseSchemaRow(metadata.getSchemaName()));
        }
        this.refreshRows();
    }

    private void clear() {
        this.rows.clear();
        this.refreshRows();
    }

    private void refreshRows() {
        this.dataProvider.updateRowCount(this.rows.size(), true);
        this.dataProvider.updateRowData(0, this.rows);
        this.view.redraw();
    }

    public static class Settings {
        private String dataSourceUuid;

        public String dataSourceUuid() {
            return this.dataSourceUuid;
        }

        public Settings dataSourceUuid(String selectedDataSourceUuid) {
            this.dataSourceUuid = selectedDataSourceUuid;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Settings settings = (Settings)o;
            return this.dataSourceUuid != null ? this.dataSourceUuid.equals(settings.dataSourceUuid) : settings.dataSourceUuid == null;
        }

        public int hashCode() {
            int result = this.dataSourceUuid != null ? this.dataSourceUuid.hashCode() : 0;
            result = ~(~result);
            return result;
        }
    }
}

