/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.widgets.BreadcrumbItemView;

@Templated
public class BreadcrumbItemViewImpl
implements BreadcrumbItemView,
IsElement {
    private BreadcrumbItemView.Presenter presenter;
    @Inject
    @DataField(value="breadcrumb-item")
    private ListItem item;
    @Inject
    @DataField(value="breadcrumb-item-anchor")
    private Anchor itemAnchorContent;
    @Inject
    private Document document;
    private HTMLElement itemStrongContent;
    private String name;

    @PostConstruct
    private void init() {
        this.itemStrongContent = this.document.createElement("strong");
    }

    public void init(BreadcrumbItemView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.adjustItemContent();
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            DOMUtil.addCSSClass((HTMLElement)this.item, (String)"active");
        } else {
            DOMUtil.removeCSSClass((HTMLElement)this.item, (String)"active");
        }
        this.adjustItemContent();
    }

    private void adjustItemContent() {
        boolean isActive = DOMUtil.hasCSSClass((HTMLElement)this.item, (String)"active");
        DOMUtil.removeAllChildren((Node)this.item);
        if (isActive) {
            this.itemStrongContent.setTextContent(this.name);
            this.item.appendChild((Node)this.itemStrongContent);
        } else {
            this.itemAnchorContent.setTextContent(this.name);
            this.item.appendChild((Node)this.itemAnchorContent);
        }
    }

    @EventHandler(value={"breadcrumb-item-anchor"})
    private void onItemClick(ClickEvent event) {
        this.presenter.onClick();
    }
}

