/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.datasource.selector;

import com.google.gwt.view.client.ListDataProvider;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datamodeller.client.widgets.datasourceselector.DataSourceInfo;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.selector.DataSourceSelectorPageRow;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.selector.DataSourceSelectorView;
import org.kie.workbench.common.screens.datasource.management.client.util.PopupsUtil;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class DataSourceSelector
implements DataSourceSelectorView.Presenter,
org.kie.workbench.common.screens.datamodeller.client.widgets.datasourceselector.DataSourceSelector {
    private DataSourceSelectorView view;
    private PopupsUtil popupsUtil;
    private TranslationService translationService;
    private ListDataProvider<DataSourceSelectorPageRow> dataProvider = new ListDataProvider();
    private ParameterizedCommand<DataSourceInfo> onSelectCommand;
    private Module module;
    private Command onCloseCommand;
    private Caller<DataSourceDefQueryService> queryService;

    public DataSourceSelector() {
    }

    @Inject
    public DataSourceSelector(DataSourceSelectorView view, PopupsUtil popupsUtil, TranslationService translationService, Caller<DataSourceDefQueryService> queryService) {
        this.view = view;
        this.queryService = queryService;
        this.popupsUtil = popupsUtil;
        this.translationService = translationService;
        view.init(this);
        this.dataProvider.addDataDisplay(view.getDisplay());
    }

    public void setModuleSelection(Module module) {
        this.module = module;
    }

    public void setGlobalSelection() {
        this.module = null;
    }

    public boolean isGlobalSelection() {
        return this.module == null;
    }

    public void show(ParameterizedCommand<DataSourceInfo> onSelectCommand, Command onCloseCommand) {
        this.onSelectCommand = onSelectCommand;
        this.onCloseCommand = onCloseCommand;
        if (this.isGlobalSelection()) {
            ((DataSourceDefQueryService)this.queryService.call(this.getLoadSuccessCallback(), this.getLoadErrorCallback())).findGlobalDataSources(true);
        } else {
            ((DataSourceDefQueryService)this.queryService.call(this.getLoadSuccessCallback(), this.getLoadErrorCallback())).findModuleDataSources(this.module);
        }
    }

    @Override
    public void onClose() {
        this.dataProvider.getList().clear();
        if (this.onCloseCommand != null) {
            this.onCloseCommand.execute();
        }
    }

    @Override
    public void onSelect() {
        if (this.onSelectCommand != null) {
            this.onSelectCommand.execute((Object)new DataSourceInfo(){

                public boolean isDeployed() {
                    return DataSourceSelector.this.view.getSelectedRow().getDataSourceDefInfo().isDeployed();
                }

                public String getJndi() {
                    if (DataSourceSelector.this.view.getSelectedRow().getDataSourceDefInfo().getDeploymentInfo() != null) {
                        return DataSourceSelector.this.view.getSelectedRow().getDataSourceDefInfo().getDeploymentInfo().getJndi();
                    }
                    return null;
                }

                public String getUuid() {
                    return DataSourceSelector.this.view.getSelectedRow().getDataSourceDefInfo().getUuid();
                }
            });
        }
    }

    private RemoteCallback<Collection<DataSourceDefInfo>> getLoadSuccessCallback() {
        return new RemoteCallback<Collection<DataSourceDefInfo>>(){

            public void callback(Collection<DataSourceDefInfo> dataSourceDefInfos) {
                DataSourceSelector.this.loadDataSources(dataSourceDefInfos);
            }
        };
    }

    private ErrorCallback<?> getLoadErrorCallback() {
        return new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                DataSourceSelector.this.popupsUtil.showErrorPopup(DataSourceSelector.this.translationService.format("DataSourceSelector.DataSourcesLoadError", new Object[0]));
                DataSourceSelector.this.onClose();
                return false;
            }
        };
    }

    private void loadDataSources(Collection<DataSourceDefInfo> dataSourceDefInfos) {
        this.dataProvider.getList().clear();
        for (DataSourceDefInfo defInfo : dataSourceDefInfos) {
            this.dataProvider.getList().add(new DataSourceSelectorPageRow(defInfo));
        }
        this.dataProvider.flush();
        this.view.show();
    }
}

