/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer.project;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerBase;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerContent;
import org.kie.workbench.common.screens.datasource.management.client.explorer.project.ModuleDataSourceExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.explorer.project.ModuleSelectorHandler;
import org.kie.workbench.common.screens.datasource.management.client.wizard.datasource.NewDataSourceDefWizard;
import org.kie.workbench.common.screens.datasource.management.client.wizard.driver.NewDriverDefWizard;
import org.kie.workbench.common.screens.datasource.management.events.BaseDataSourceEvent;
import org.kie.workbench.common.screens.datasource.management.events.BaseDriverEvent;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQuery;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQueryResult;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQueryService;

@Dependent
public class ModuleDataSourceExplorer
extends DefExplorerBase
implements ModuleDataSourceExplorerView.Presenter,
IsWidget {
    private ModuleDataSourceExplorerView view;
    private OrganizationalUnit activeOrganizationalUnit;
    private Repository activeRepository;
    private Module activeModule;

    @Inject
    public ModuleDataSourceExplorer(ModuleDataSourceExplorerView view, DefExplorerContent defExplorerContent, NewDataSourceDefWizard newDataSourceDefWizard, NewDriverDefWizard newDriverDefWizard, Caller<DefExplorerQueryService> explorerService) {
        super(defExplorerContent, newDataSourceDefWizard, newDriverDefWizard, explorerService);
        this.view = view;
    }

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.view.setDataSourceDefExplorer(this.defExplorerContent);
        this.view.addModuleSelectorHandler(new ModuleSelectorHandler(){

            @Override
            public void onOrganizationalUnitSelected(OrganizationalUnit ou) {
                ModuleDataSourceExplorer.this.onOrganizationalUnitSelected(ou);
            }

            @Override
            public void onRepositorySelected(Repository repository) {
                ModuleDataSourceExplorer.this.onRepositorySelected(repository);
            }

            @Override
            public void onModuleSelected(Module module) {
                ModuleDataSourceExplorer.this.onModuleSelected(module);
            }
        });
    }

    @Override
    public void onAddDriver() {
        Module activeModule = this.getActiveModule();
        if (activeModule == null) {
            Window.alert((String)"No module has been selected");
        } else {
            this.newDriverDefWizard.setModule(activeModule);
            this.newDriverDefWizard.start();
        }
    }

    @Override
    public void onAddDataSource() {
        Module activeModule = this.getActiveModule();
        if (activeModule == null) {
            Window.alert((String)"No module has been selected");
        } else {
            this.newDataSourceDefWizard.setModule(this.getActiveModule());
            this.newDataSourceDefWizard.start();
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    protected DefExplorerQuery createRefreshQuery() {
        return new DefExplorerQuery(this.activeOrganizationalUnit, this.activeRepository, this.activeModule, ((Branch)this.activeRepository.getDefaultBranch().get()).getName());
    }

    private void refresh(DefExplorerQuery query) {
        ((DefExplorerQueryService)this.explorerService.call(this.getRefreshCallback())).executeQuery(query);
    }

    @Override
    protected void loadContent(DefExplorerQueryResult content) {
        this.defExplorerContent.clear();
        if (this.activeOrganizationalUnit == null || !this.contains(content.getOrganizationalUnits(), this.activeOrganizationalUnit)) {
            if (content.getOrganizationalUnits() != null && content.getOrganizationalUnits().size() > 0) {
                this.activeOrganizationalUnit = (OrganizationalUnit)content.getOrganizationalUnits().iterator().next();
                this.activeRepository = null;
                this.activeModule = null;
                this.refresh();
            } else {
                this.activeOrganizationalUnit = null;
                this.activeRepository = null;
                this.activeModule = null;
                this.view.clear();
            }
        } else if (this.activeRepository == null || !this.contains(content.getRepositories(), this.activeRepository)) {
            if (content.getRepositories() != null && content.getRepositories().size() > 0) {
                this.activeRepository = (Repository)content.getRepositories().iterator().next();
                this.activeModule = null;
                this.refresh();
            } else {
                this.activeRepository = null;
                this.activeModule = null;
                this.view.loadContent(content.getOrganizationalUnits(), this.activeOrganizationalUnit, new ArrayList<Repository>(), this.activeRepository, new ArrayList<Module>(), this.activeModule);
            }
        } else if (this.activeModule == null || !this.contains(content.getModules(), this.activeModule)) {
            if (content.getModules() != null && content.getModules().size() > 0) {
                this.activeModule = (Module)content.getModules().iterator().next();
                this.refresh();
            } else {
                this.activeModule = null;
                this.view.loadContent(content.getOrganizationalUnits(), this.activeOrganizationalUnit, content.getRepositories(), this.activeRepository, new ArrayList<Module>(), this.activeModule);
            }
        } else {
            this.view.loadContent(content.getOrganizationalUnits(), this.activeOrganizationalUnit, content.getRepositories(), this.activeRepository, content.getModules(), this.activeModule);
            this.defExplorerContent.loadDataSources(content.getDataSourceDefs());
            this.defExplorerContent.loadDrivers(content.getDriverDefs());
        }
    }

    private boolean contains(Collection<Repository> repositories, Repository activeRepository) {
        if (repositories != null) {
            for (Repository repository : repositories) {
                if (!repository.getAlias().equals(activeRepository.getAlias())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(Collection<OrganizationalUnit> organizationalUnits, OrganizationalUnit activeOrganizationalUnit) {
        if (organizationalUnits != null) {
            for (OrganizationalUnit ou : organizationalUnits) {
                if (!ou.getName().equals(activeOrganizationalUnit.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(Collection<Module> modules, Module activeModule) {
        if (modules != null) {
            for (Module module : modules) {
                if (!module.getRootPath().equals(activeModule.getRootPath())) continue;
                return true;
            }
        }
        return false;
    }

    public void onOrganizationalUnitSelected(OrganizationalUnit ou) {
        if (this.hasChanged(ou)) {
            this.activeOrganizationalUnit = ou;
            this.activeRepository = null;
            this.activeModule = null;
            DefExplorerQuery query = new DefExplorerQuery();
            query.setOrganizationalUnit(ou);
            this.refresh(query);
        }
    }

    public void onRepositorySelected(Repository repository) {
        if (this.hasChanged(repository)) {
            DefExplorerQuery query = new DefExplorerQuery();
            if (this.activeOrganizationalUnit != null) {
                this.activeRepository = repository;
                this.activeModule = null;
                query.setOrganizationalUnit(this.activeOrganizationalUnit);
                query.setRepository(repository);
                query.setBranchName(((Branch)this.activeRepository.getDefaultBranch().get()).getName());
            } else {
                this.activeRepository = null;
                this.activeModule = null;
            }
            this.refresh(query);
        }
    }

    public void onModuleSelected(Module module) {
        if (this.hasChanged(module)) {
            DefExplorerQuery query = new DefExplorerQuery();
            if (this.activeOrganizationalUnit != null && this.activeRepository != null) {
                this.activeModule = module;
                query.setOrganizationalUnit(this.activeOrganizationalUnit);
                query.setRepository(this.activeRepository);
                query.setBranchName(((Branch)this.activeRepository.getDefaultBranch().get()).getName());
                query.setModule(module);
            } else {
                this.activeModule = null;
            }
            this.refresh(query);
        }
    }

    public OrganizationalUnit getActiveOrganizationalUnit() {
        return this.activeOrganizationalUnit;
    }

    public void setActiveOrganizationalUnit(OrganizationalUnit activeOrganizationalUnit) {
        this.activeOrganizationalUnit = activeOrganizationalUnit;
    }

    public Repository getActiveRepository() {
        return this.activeRepository;
    }

    public void setActiveRepository(Repository activeRepository) {
        this.activeRepository = activeRepository;
    }

    public Module getActiveModule() {
        return this.activeModule;
    }

    public void setActiveModule(Module activeModule) {
        this.activeModule = activeModule;
    }

    @Override
    protected boolean refreshOnDataSourceEvent(BaseDataSourceEvent event) {
        return !event.isGlobal() && this.activeModule != null && this.activeModule.equals((Object)event.getModule());
    }

    @Override
    protected boolean refreshOnDriverEvent(BaseDriverEvent event) {
        return !event.isGlobal() && this.activeModule != null && this.activeModule.equals((Object)event.getModule());
    }

    private boolean hasChanged(OrganizationalUnit ou) {
        return this.activeOrganizationalUnit != null ? !this.activeOrganizationalUnit.equals(ou) : ou != null;
    }

    private boolean hasChanged(Repository repository) {
        return this.activeRepository != null ? !this.activeRepository.equals(repository) : repository != null;
    }

    private boolean hasChanged(Module module) {
        return this.activeModule != null ? !this.activeModule.equals((Object)module) : module != null;
    }
}

