/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.dbcp;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverProvider;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.util.MavenArtifactResolver;

@ApplicationScoped
@Named(value="DBCPDriverProvider")
public class DBCPDriverProvider
implements DriverProvider {
    private MavenArtifactResolver artifactResolver;
    private Map<String, URI> deployedUris = new HashMap<String, URI>();
    private Map<String, DriverDeploymentInfo> deploymentInfos = new HashMap<String, DriverDeploymentInfo>();
    private Map<String, DriverDef> deployedDrivers = new HashMap<String, DriverDef>();

    public DBCPDriverProvider() {
    }

    @Inject
    public DBCPDriverProvider(MavenArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public DriverDeploymentInfo deploy(DriverDef driverDef) throws Exception {
        URI uri = this.artifactResolver.resolve(driverDef.getGroupId(), driverDef.getArtifactId(), driverDef.getVersion());
        if (uri == null) {
            throw new Exception("Unable to get driver library artifact for driver: " + driverDef);
        }
        DriverDeploymentInfo deploymentInfo = new DriverDeploymentInfo(driverDef.getUuid(), driverDef.getUuid(), true, driverDef.getUuid(), driverDef.getDriverClass());
        this.deployedUris.put(driverDef.getUuid(), uri);
        this.deploymentInfos.put(driverDef.getUuid(), deploymentInfo);
        this.deployedDrivers.put(driverDef.getUuid(), driverDef);
        return deploymentInfo;
    }

    public DriverDeploymentInfo resync(DriverDef driverDef, DriverDeploymentInfo deploymentInfo) throws Exception {
        return deploymentInfo;
    }

    public void undeploy(DriverDeploymentInfo deploymentInfo) throws Exception {
        this.deployedUris.remove(deploymentInfo.getDeploymentId());
        this.deploymentInfos.remove(deploymentInfo.getDeploymentId());
        this.deployedDrivers.remove(deploymentInfo.getDeploymentId());
    }

    public DriverDeploymentInfo getDeploymentInfo(String uuid) throws Exception {
        return this.deploymentInfos.get(uuid);
    }

    public List<DriverDeploymentInfo> getDeploymentsInfo() throws Exception {
        ArrayList<DriverDeploymentInfo> result = new ArrayList<DriverDeploymentInfo>();
        result.addAll(this.deploymentInfos.values());
        return result;
    }

    public List<DriverDef> getDeployments() {
        ArrayList<DriverDef> results = new ArrayList<DriverDef>();
        results.addAll(this.deployedDrivers.values());
        return results;
    }

    public void loadConfig(Properties properties) {
    }
}

