/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.dbcp;

import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSource;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.dbcp.DBCPDriverProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.impl.AbstractDataSource;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceStatus;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.util.MavenArtifactResolver;
import org.kie.workbench.common.screens.datasource.management.util.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="DBCPDataSourceProvider")
public class DBCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(DBCPDataSourceProvider.class);
    private DBCPDriverProvider driverProvider;
    private MavenArtifactResolver artifactResolver;
    private Map<String, DBCPDataSource> deploymentRegistry = new HashMap<String, DBCPDataSource>();
    private Map<String, DataSourceDeploymentInfo> deploymentInfos = new HashMap<String, DataSourceDeploymentInfo>();
    private Map<String, DataSourceDef> deployedDataSources = new HashMap<String, DataSourceDef>();

    public DBCPDataSourceProvider() {
    }

    @Inject
    public DBCPDataSourceProvider(DBCPDriverProvider driverProvider, MavenArtifactResolver artifactResolver) {
        this.driverProvider = driverProvider;
        this.artifactResolver = artifactResolver;
    }

    public DataSourceDeploymentInfo deploy(DataSourceDef dataSourceDef) throws Exception {
        DriverDef driverDef = null;
        for (DriverDef _driverDef : this.driverProvider.getDeployments()) {
            if (!_driverDef.getUuid().equals(dataSourceDef.getDriverUuid())) continue;
            driverDef = _driverDef;
            break;
        }
        if (driverDef == null) {
            throw new Exception("Required driver: " + dataSourceDef.getDriverUuid() + " is not deployed");
        }
        URI uri = this.artifactResolver.resolve(driverDef.getGroupId(), driverDef.getArtifactId(), driverDef.getVersion());
        if (uri == null) {
            throw new Exception("Unable to get driver library artifact for driver: " + driverDef);
        }
        Properties properties = new Properties();
        properties.setProperty("user", dataSourceDef.getUser());
        properties.setProperty("password", dataSourceDef.getPassword());
        URLConnectionFactory urlConnectionFactory = this.buildConnectionFactory(uri, driverDef.getDriverClass(), dataSourceDef.getConnectionURL(), properties);
        DBCPConnectionFactory connectionFactory = new DBCPConnectionFactory(urlConnectionFactory);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        DataSourceDeploymentInfo deploymentInfo = new DataSourceDeploymentInfo(dataSourceDef.getUuid(), true, dataSourceDef.getUuid(), false);
        this.deploymentRegistry.put(deploymentInfo.getDeploymentId(), new DBCPDataSource(dataSource));
        this.deploymentInfos.put(deploymentInfo.getDeploymentId(), deploymentInfo);
        this.deployedDataSources.put(deploymentInfo.getDeploymentId(), dataSourceDef);
        return deploymentInfo;
    }

    public DataSourceDeploymentInfo resync(DataSourceDef dataSourceDef, DataSourceDeploymentInfo deploymentInfo) throws Exception {
        return deploymentInfo;
    }

    public void undeploy(DataSourceDeploymentInfo deploymentInfo) throws Exception {
        DataSourceDeploymentInfo currentDeploymentInfo = this.deploymentInfos.get(deploymentInfo.getDeploymentId());
        if (currentDeploymentInfo == null) {
            throw new Exception("DataSource: " + deploymentInfo.getUuid() + " is not deployed");
        }
        DBCPDataSource dataSource = this.deploymentRegistry.remove(currentDeploymentInfo.getDeploymentId());
        if (dataSource != null) {
            try {
                dataSource.close();
            }
            catch (Exception e) {
                logger.warn("An error was produced during datasource close", (Throwable)e);
            }
        }
        this.deploymentRegistry.remove(currentDeploymentInfo.getDeploymentId());
        this.deployedDataSources.remove(currentDeploymentInfo.getDeploymentId());
        this.deploymentInfos.remove(currentDeploymentInfo.getDeploymentId());
    }

    public DataSourceDeploymentInfo getDeploymentInfo(String uuid) throws Exception {
        return this.deploymentInfos.get(uuid);
    }

    public List<DataSourceDeploymentInfo> getDeploymentsInfo() throws Exception {
        ArrayList<DataSourceDeploymentInfo> result = new ArrayList<DataSourceDeploymentInfo>();
        result.addAll(this.deploymentInfos.values());
        return result;
    }

    public List<DataSourceDef> getDeployments() throws Exception {
        ArrayList<DataSourceDef> result = new ArrayList<DataSourceDef>();
        result.addAll(this.deployedDataSources.values());
        return result;
    }

    public void loadConfig(Properties properties) {
    }

    public DataSource lookupDataSource(DataSourceDeploymentInfo deploymentInfo) throws Exception {
        DBCPDataSource dataSource = this.deploymentRegistry.get(deploymentInfo.getDeploymentId());
        if (dataSource != null) {
            DataSourceDeploymentInfo _deploymentInfo;
            if (dataSource.isNew()) {
                dataSource.setStatus(DataSourceStatus.REFERENCED);
            }
            if ((_deploymentInfo = this.deploymentInfos.get(deploymentInfo.getDeploymentId())) != null) {
                DataSourceDeploymentInfo updatedDeploymentInfo = new DataSourceDeploymentInfo(deploymentInfo.getDeploymentId(), true, deploymentInfo.getUuid(), true);
                this.deploymentInfos.put(deploymentInfo.getDeploymentId(), updatedDeploymentInfo);
            }
            return dataSource;
        }
        throw new Exception("Data source for: " + deploymentInfo + " is not deployed in current system.");
    }

    protected URLConnectionFactory buildConnectionFactory(URI uri, String driverClass, String connectionURL, Properties connectionProperties) throws Exception {
        return new URLConnectionFactory(uri.toURL(), driverClass, connectionURL, connectionProperties);
    }

    private class DBCPDataSource
    extends AbstractDataSource {
        public DBCPDataSource(PoolingDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Connection getConnection() throws Exception {
            return this.dataSource.getConnection();
        }

        public void setStatus(DataSourceStatus status) {
            this.status = status;
            this.notifyStatusChange(status);
        }

        public void close() throws Exception {
            ((PoolingDataSource)this.dataSource).close();
        }
    }

    private class DBCPConnectionFactory
    implements ConnectionFactory {
        URLConnectionFactory urlConnectionFactory;

        public DBCPConnectionFactory(URLConnectionFactory urlConnectionFactory) {
            this.urlConnectionFactory = urlConnectionFactory;
        }

        public Connection createConnection() throws SQLException {
            return this.urlConnectionFactory.createConnection();
        }
    }
}

