/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.wildfly;

import java.util.UUID;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;

public class DeploymentIdGenerator {
    public static String extractUuid(String deploymentId) throws Exception {
        if (deploymentId == null || deploymentId.length() < 40 || !deploymentId.startsWith("kie-")) {
            throw new Exception("Unknown deployment identifier." + deploymentId);
        }
        String uuid = deploymentId.substring(4, 40);
        try {
            UUID.fromString(uuid);
            return uuid;
        }
        catch (Exception e) {
            throw new Exception("Unknown deployment identifier." + deploymentId);
        }
    }

    public static String generateDeploymentId(DriverDef driverDef) {
        return DeploymentIdGenerator.generateDeploymentId(driverDef.getUuid());
    }

    public static String generateDeploymentId(DataSourceDef dataSourceDef) {
        return DeploymentIdGenerator.generateDeploymentId(dataSourceDef.getUuid());
    }

    public static String generateDeploymentId(String uuid) {
        return "kie-" + uuid;
    }
}

