/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.wildfly;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.wildfly.DeploymentIdGenerator;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDriverDef;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDriverManagementClient;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.util.MavenArtifactResolver;

@ApplicationScoped
@Named(value="WildflyDriverProvider")
public class WildflyDriverProvider
implements DriverProvider {
    @Inject
    private MavenArtifactResolver artifactResolver;
    private WildflyDriverManagementClient driverMgmtClient = new WildflyDriverManagementClient();
    private Map<String, DriverDeploymentInfo> managedDrivers = new HashMap<String, DriverDeploymentInfo>();

    public DriverDeploymentInfo deploy(DriverDef driverDef) throws Exception {
        URI uri = this.artifactResolver.resolve(driverDef.getGroupId(), driverDef.getArtifactId(), driverDef.getVersion());
        if (uri == null) {
            throw new Exception("Unable to get driver library artifact for driver: " + driverDef);
        }
        String deploymentId = DeploymentIdGenerator.generateDeploymentId(driverDef);
        this.driverMgmtClient.deploy(deploymentId, uri);
        DriverDeploymentInfo deploymentInfo = new DriverDeploymentInfo(deploymentId, true, driverDef.getUuid(), driverDef.getDriverClass());
        this.managedDrivers.put(deploymentInfo.getDeploymentId(), deploymentInfo);
        return deploymentInfo;
    }

    public DriverDeploymentInfo resync(DriverDef driverDef, DriverDeploymentInfo deploymentInfo) throws Exception {
        this.managedDrivers.put(deploymentInfo.getDeploymentId(), deploymentInfo);
        return deploymentInfo;
    }

    public void undeploy(DriverDeploymentInfo deploymentInfo) throws Exception {
        this.driverMgmtClient.undeploy(deploymentInfo.getDeploymentId());
        this.managedDrivers.remove(deploymentInfo.getDeploymentId());
    }

    public DriverDeploymentInfo getDeploymentInfo(String uuid) throws Exception {
        for (DriverDeploymentInfo deploymentInfo : this.getDeploymentsInfo()) {
            if (!uuid.equals(deploymentInfo.getUuid())) continue;
            return deploymentInfo;
        }
        return null;
    }

    public List<DriverDef> getDeployments() throws Exception {
        ArrayList<DriverDef> driverDefs = new ArrayList<DriverDef>();
        for (WildflyDriverDef internalDef : this.driverMgmtClient.getDeployedDrivers()) {
            String uuid;
            DriverDef driverDef = new DriverDef();
            try {
                uuid = DeploymentIdGenerator.extractUuid(internalDef.getDriverName());
            }
            catch (Exception e) {
                uuid = internalDef.getDriverName();
            }
            driverDef.setUuid(uuid);
            driverDef.setName(internalDef.getDeploymentName());
            driverDef.setDriverClass(internalDef.getDriverClass());
            driverDefs.add(driverDef);
        }
        return driverDefs;
    }

    public List<DriverDeploymentInfo> getDeploymentsInfo() throws Exception {
        ArrayList<DriverDeploymentInfo> deploymentsInfo = new ArrayList<DriverDeploymentInfo>();
        for (WildflyDriverDef internalDef : this.driverMgmtClient.getDeployedDrivers()) {
            String uuid;
            try {
                uuid = DeploymentIdGenerator.extractUuid(internalDef.getDriverName());
            }
            catch (Exception e) {
                uuid = internalDef.getDriverName();
            }
            boolean managed = this.managedDrivers.containsKey(internalDef.getDriverName());
            DriverDeploymentInfo deploymentInfo = new DriverDeploymentInfo(internalDef.getDriverName(), managed, uuid, internalDef.getDriverClass());
            deploymentsInfo.add(deploymentInfo);
        }
        return deploymentsInfo;
    }

    public void loadConfig(Properties properties) {
        this.driverMgmtClient.loadConfig(properties);
    }
}

