/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.wildfly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSource;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.wildfly.DeploymentIdGenerator;
import org.kie.workbench.common.screens.datasource.management.backend.core.wildfly.JndiNameGenerator;
import org.kie.workbench.common.screens.datasource.management.backend.core.wildfly.WildflyDriverProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.wildfly.WildlfyDataSource;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDataSourceDef;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDataSourceManagementClient;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceStatus;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.util.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="WildflyDataSourceProvider")
public class WildflyDataSourceProvider
implements DataSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(WildflyDataSourceProvider.class);
    private WildflyDriverProvider driverProvider;
    private WildflyDataSourceManagementClient dataSourceMgmtClient = new WildflyDataSourceManagementClient();
    private Map<String, WildlfyDataSource> managedDataSources = new HashMap<String, WildlfyDataSource>();
    private Map<String, WildlfyDataSource> unManagedDataSources = new HashMap<String, WildlfyDataSource>();

    public WildflyDataSourceProvider() {
    }

    @Inject
    public WildflyDataSourceProvider(WildflyDriverProvider driverProvider) {
        this.driverProvider = driverProvider;
    }

    public List<DataSourceDef> getDeployments() throws Exception {
        ArrayList<DataSourceDef> dataSourceDefs = new ArrayList<DataSourceDef>();
        List<WildflyDataSourceDef> dataSources = this.dataSourceMgmtClient.getDataSources();
        for (WildflyDataSourceDef internalDef : dataSources) {
            String driverUuid;
            String dataSourceUuid;
            DataSourceDef dataSourceDef = new DataSourceDef();
            try {
                dataSourceUuid = DeploymentIdGenerator.extractUuid(internalDef.getName());
            }
            catch (Exception e) {
                dataSourceUuid = internalDef.getName();
            }
            try {
                driverUuid = DeploymentIdGenerator.extractUuid(internalDef.getDriverName());
            }
            catch (Exception e) {
                driverUuid = internalDef.getDriverName();
            }
            dataSourceDef.setUuid(dataSourceUuid);
            dataSourceDef.setName(internalDef.getName());
            dataSourceDef.setConnectionURL(internalDef.getConnectionURL());
            dataSourceDef.setDriverUuid(driverUuid);
            dataSourceDef.setUser(internalDef.getUser());
            dataSourceDef.setPassword(internalDef.getPassword());
            dataSourceDefs.add(dataSourceDef);
        }
        return dataSourceDefs;
    }

    public DataSourceDeploymentInfo deploy(DataSourceDef dataSourceDef) throws Exception {
        String random = "_" + this.generateRandomUUID();
        String deploymentId = DeploymentIdGenerator.generateDeploymentId(dataSourceDef) + random;
        String kieJndi = JndiNameGenerator.generateJNDIName(dataSourceDef);
        String deploymentJndi = kieJndi + random;
        DataSourceDeploymentInfo deploymentInfo = this.deploy(dataSourceDef, deploymentJndi, deploymentId);
        javax.sql.DataSource dataSource = (javax.sql.DataSource)this.jndiLookupDataSource(deploymentJndi);
        WildlfyDataSource wfDataSource = new WildlfyDataSource(dataSource, deploymentJndi);
        this.managedDataSources.put(deploymentId, wfDataSource);
        return deploymentInfo;
    }

    protected String generateRandomUUID() {
        return UUIDGenerator.generateUUID();
    }

    private DataSourceDeploymentInfo deploy(DataSourceDef dataSourceDef, String jndi, String deploymentId) throws Exception {
        DriverDeploymentInfo driverDeploymentInfo = this.driverProvider.getDeploymentInfo(dataSourceDef.getDriverUuid());
        if (driverDeploymentInfo == null) {
            throw new Exception("Required driver: " + dataSourceDef.getDriverUuid() + " is not deployed.");
        }
        WildflyDataSourceDef wfDataSourceDef = this.buildWFDataSource(deploymentId, jndi, dataSourceDef, driverDeploymentInfo.getDriverDeploymentId());
        this.dataSourceMgmtClient.createDataSource(wfDataSourceDef);
        return new DataSourceDeploymentInfo(deploymentId, true, dataSourceDef.getUuid(), jndi, false);
    }

    public DataSourceDeploymentInfo resync(DataSourceDef dataSourceDef, DataSourceDeploymentInfo deploymentInfo) throws Exception {
        javax.sql.DataSource dataSource = (javax.sql.DataSource)this.jndiLookupDataSource(deploymentInfo.getJndi());
        WildlfyDataSource wfDataSource = new WildlfyDataSource(dataSource, deploymentInfo.getJndi());
        this.managedDataSources.put(deploymentInfo.getDeploymentId(), wfDataSource);
        return deploymentInfo;
    }

    public void undeploy(DataSourceDeploymentInfo deploymentInfo) throws Exception {
        DataSourceDeploymentInfo currentDeploymentInfo = this.getDeploymentInfo(deploymentInfo.getUuid());
        if (currentDeploymentInfo == null) {
            throw new Exception("DataSource: " + deploymentInfo.getUuid() + " is not deployed");
        }
        this.dataSourceMgmtClient.deleteDataSource(currentDeploymentInfo.getDeploymentId());
        this.managedDataSources.remove(currentDeploymentInfo.getDeploymentId());
    }

    public DataSourceDeploymentInfo getDeploymentInfo(String uuid) throws Exception {
        for (DataSourceDeploymentInfo deploymentInfo : this.getDeploymentsInfo()) {
            if (!uuid.equals(deploymentInfo.getUuid())) continue;
            return deploymentInfo;
        }
        return null;
    }

    public List<DataSourceDeploymentInfo> getDeploymentsInfo() throws Exception {
        List<WildflyDataSourceDef> dataSources = this.dataSourceMgmtClient.getDataSources();
        ArrayList<DataSourceDeploymentInfo> result = new ArrayList<DataSourceDeploymentInfo>();
        for (WildflyDataSourceDef internalDef : dataSources) {
            String jndi;
            boolean managed;
            String uuid;
            try {
                uuid = DeploymentIdGenerator.extractUuid(internalDef.getName());
            }
            catch (Exception e) {
                uuid = internalDef.getName();
            }
            WildlfyDataSource managedDataSource = this.managedDataSources.get(internalDef.getName());
            if (managedDataSource != null) {
                managed = true;
                jndi = managedDataSource.getExternalJndi();
            } else {
                managed = false;
                jndi = internalDef.getJndi();
            }
            DataSourceDeploymentInfo deploymentInfo = new DataSourceDeploymentInfo(internalDef.getName(), managed, uuid, jndi, this.wasReferenced(internalDef.getName()));
            result.add(deploymentInfo);
        }
        return result;
    }

    public DataSource lookupDataSource(DataSourceDeploymentInfo deploymentInfo) throws Exception {
        javax.sql.DataSource sqlDataSource;
        DataSourceDeploymentInfo refreshedDeploymentInfo;
        WildlfyDataSource dataSource = this.managedDataSources.get(deploymentInfo.getDeploymentId());
        if (dataSource == null) {
            dataSource = this.unManagedDataSources.get(deploymentInfo.getDeploymentId());
        }
        if (dataSource == null && (refreshedDeploymentInfo = this.getDeploymentInfo(deploymentInfo.getUuid())) != null && refreshedDeploymentInfo.getJndi() != null && (sqlDataSource = (javax.sql.DataSource)this.jndiLookupDataSource(refreshedDeploymentInfo.getJndi())) != null) {
            dataSource = new WildlfyDataSource(sqlDataSource, refreshedDeploymentInfo.getJndi());
            this.unManagedDataSources.put(deploymentInfo.getDeploymentId(), dataSource);
            return dataSource;
        }
        if (dataSource != null) {
            if (dataSource.isNew()) {
                dataSource.setStatus(DataSourceStatus.REFERENCED);
            }
            return dataSource;
        }
        throw new Exception("Data source for: " + deploymentInfo + " is not deployed in current system.");
    }

    public void loadConfig(Properties properties) {
        this.dataSourceMgmtClient.loadConfig(properties);
        this.driverProvider.loadConfig(properties);
    }

    protected Object jndiLookupDataSource(String jndi) {
        try {
            InitialContext context = new InitialContext();
            return context.lookup(jndi);
        }
        catch (Exception e) {
            logger.warn("JNDI lookup failed for name: {}", (Object)jndi);
            return null;
        }
    }

    private WildflyDataSourceDef buildWFDataSource(String deploymentId, String jndi, DataSourceDef dataSourceDef, String driverDeploymentId) {
        WildflyDataSourceDef wfDataSourceDef = new WildflyDataSourceDef();
        wfDataSourceDef.setName(deploymentId);
        wfDataSourceDef.setDriverName(driverDeploymentId);
        wfDataSourceDef.setJndi(jndi);
        wfDataSourceDef.setConnectionURL(dataSourceDef.getConnectionURL());
        wfDataSourceDef.setUser(dataSourceDef.getUser());
        wfDataSourceDef.setPassword(dataSourceDef.getPassword());
        wfDataSourceDef.setUseJTA(true);
        return wfDataSourceDef;
    }

    private boolean wasReferenced(String deploymentId) {
        WildlfyDataSource dataSource = this.managedDataSources.get(deploymentId);
        if (dataSource == null) {
            dataSource = this.unManagedDataSources.get(deploymentId);
        }
        if (dataSource != null) {
            return dataSource.isReferenced();
        }
        return false;
    }

    public void setDataSourceMgmtClient(WildflyDataSourceManagementClient dataSourceMgmtClient) {
        this.dataSourceMgmtClient = dataSourceMgmtClient;
    }
}

