/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.wildfly;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.wildfly.DeploymentIdGenerator;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDriverDef;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDriverManagementClient;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.util.MavenArtifactResolver;

@ApplicationScoped
@Named(value="WildflyDriverProvider")
public class WildflyDriverProvider
implements DriverProvider {
    private MavenArtifactResolver artifactResolver;
    private WildflyDriverManagementClient driverMgmtClient = new WildflyDriverManagementClient();
    private Map<String, DriverDeploymentInfo> managedDrivers = new HashMap<String, DriverDeploymentInfo>();

    public WildflyDriverProvider() {
    }

    @Inject
    public WildflyDriverProvider(MavenArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public DriverDeploymentInfo deploy(DriverDef driverDef) throws Exception {
        URI uri = this.artifactResolver.resolve(driverDef.getGroupId(), driverDef.getArtifactId(), driverDef.getVersion());
        if (uri == null) {
            throw new Exception("Unable to get driver library artifact for driver: " + driverDef);
        }
        String deploymentId = DeploymentIdGenerator.generateDeploymentId(driverDef);
        this.driverMgmtClient.deploy(deploymentId, uri);
        DriverDeploymentInfo generatedDeploymentInfo = this.findDeploymentInfo(deploymentId, driverDef);
        DriverDeploymentInfo deploymentInfo = new DriverDeploymentInfo(deploymentId, generatedDeploymentInfo.getDeploymentId(), true, driverDef.getUuid(), driverDef.getDriverClass());
        this.managedDrivers.put(deploymentInfo.getDeploymentId(), deploymentInfo);
        return deploymentInfo;
    }

    public DriverDeploymentInfo resync(DriverDef driverDef, DriverDeploymentInfo deploymentInfo) throws Exception {
        String deploymentId = DeploymentIdGenerator.generateDeploymentId(driverDef);
        DriverDeploymentInfo currentDeploymentInfo = this.findDeploymentInfo(deploymentId, driverDef);
        DriverDeploymentInfo result = new DriverDeploymentInfo(deploymentId, currentDeploymentInfo.getDriverDeploymentId(), true, driverDef.getUuid(), driverDef.getDriverClass());
        this.managedDrivers.put(result.getDeploymentId(), result);
        return result;
    }

    public void undeploy(DriverDeploymentInfo deploymentInfo) throws Exception {
        this.driverMgmtClient.undeploy(deploymentInfo.getDeploymentId());
        this.managedDrivers.remove(deploymentInfo.getDeploymentId());
    }

    public DriverDeploymentInfo getDeploymentInfo(String uuid) throws Exception {
        String deploymentId = DeploymentIdGenerator.generateDeploymentId(uuid);
        DriverDeploymentInfo result = this.managedDrivers.get(deploymentId);
        if (result == null) {
            for (DriverDeploymentInfo deploymentInfo : this.getDeploymentsInfo()) {
                if (!uuid.equals(deploymentInfo.getUuid())) continue;
                result = deploymentInfo;
                break;
            }
        }
        return result;
    }

    public List<DriverDef> getDeployments() throws Exception {
        ArrayList<DriverDef> driverDefs = new ArrayList<DriverDef>();
        for (WildflyDriverDef internalDef : this.driverMgmtClient.getDeployedDrivers()) {
            String uuid;
            DriverDef driverDef = new DriverDef();
            try {
                uuid = DeploymentIdGenerator.extractUuid(internalDef.getDriverName());
            }
            catch (Exception e) {
                uuid = internalDef.getDriverName();
            }
            driverDef.setUuid(uuid);
            driverDef.setName(internalDef.getDeploymentName());
            driverDef.setDriverClass(internalDef.getDriverClass());
            driverDefs.add(driverDef);
        }
        return driverDefs;
    }

    public List<DriverDeploymentInfo> getDeploymentsInfo() throws Exception {
        ArrayList<DriverDeploymentInfo> deploymentsInfo = new ArrayList<DriverDeploymentInfo>();
        for (WildflyDriverDef internalDef : this.driverMgmtClient.getDeployedDrivers()) {
            String uuid;
            try {
                uuid = DeploymentIdGenerator.extractUuid(internalDef.getDriverName());
            }
            catch (Exception e) {
                uuid = internalDef.getDriverName();
            }
            boolean managed = this.managedDrivers.containsKey(internalDef.getDriverName());
            DriverDeploymentInfo deploymentInfo = new DriverDeploymentInfo(internalDef.getDriverName(), internalDef.getDriverName(), managed, uuid, internalDef.getDriverClass());
            deploymentsInfo.add(deploymentInfo);
        }
        return deploymentsInfo;
    }

    public void loadConfig(Properties properties) {
        this.driverMgmtClient.loadConfig(properties);
    }

    private DriverDeploymentInfo findDeploymentInfo(String deploymentId, DriverDef driverDef) throws Exception {
        for (DriverDeploymentInfo deploymentInfo : this.getDeploymentsInfo()) {
            if (!deploymentInfo.getDeploymentId().equals(deploymentId) && !deploymentInfo.getDeploymentId().startsWith(deploymentId + "_" + driverDef.getDriverClass())) continue;
            return deploymentInfo;
        }
        return null;
    }

    public void setDriverMgmtClient(WildflyDriverManagementClient driverMgmtClient) {
        this.driverMgmtClient = driverMgmtClient;
    }
}

