/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.kie.workbench.common.screens.datasource.management.util.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WildflyBaseClient {
    private static final Logger logger = LoggerFactory.getLogger(WildflyBaseClient.class);
    private static final String PREFIX = "datasource.management.wildfly";
    private static final String HOST = "datasource.management.wildfly.host";
    private static final String PORT = "datasource.management.wildfly.port";
    private static final String ADMIN = "datasource.management.wildfly.admin";
    private static final String PASSWORD = "datasource.management.wildfly.password";
    private static final String REALM = "datasource.management.wildfly.realm";
    protected static final String DEFAULT_HOST = "localhost";
    protected static final int DEFAULT_PORT = 9990;
    protected static final String DEFAULT_ADMIN = null;
    protected static final String DEFAULT_ADMIN_PASSWORD = null;
    protected static final String DEFAULT_REALM = "ApplicationRealm";
    protected String host;
    protected int port;
    protected String admin;
    protected String password;
    protected String realm;

    public void loadConfig(Properties properties) {
        try {
            this.host = ServiceUtil.getManagedProperty((Properties)properties, (String)HOST, (String)DEFAULT_HOST);
            String currentPort = null;
            try {
                currentPort = ServiceUtil.getManagedProperty((Properties)properties, (String)PORT, (String)String.valueOf(9990));
                this.port = Integer.parseInt(currentPort);
            }
            catch (Exception e) {
                logger.error("It was not possible to parse port configuration from: " + currentPort + " default port: " + 9990 + " will be used instead.");
                this.port = 9990;
            }
            this.admin = ServiceUtil.getManagedProperty((Properties)properties, (String)ADMIN, (String)DEFAULT_ADMIN);
            this.password = ServiceUtil.getManagedProperty((Properties)properties, (String)PASSWORD, (String)DEFAULT_ADMIN_PASSWORD);
            this.realm = ServiceUtil.getManagedProperty((Properties)properties, (String)REALM, (String)DEFAULT_REALM);
        }
        catch (Exception e) {
            logger.error("An error was produced during data source configuration file reading");
        }
    }

    public ModelControllerClient createControllerClient() throws Exception {
        return this.createControllerClient(true);
    }

    public ModelControllerClient createControllerClient(boolean checkConnection) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(this.host), (int)this.port, (CallbackHandler)new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(WildflyBaseClient.this.admin);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(WildflyBaseClient.this.password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(WildflyBaseClient.this.realm);
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        });
        if (checkConnection) {
            try {
                ModelNode op = new ModelNode();
                op.get("operation").set("read-resource");
                ModelNode returnVal = client.execute(new OperationBuilder(op).build());
                String releaseVersion = returnVal.get("result").get("release-version").asString();
                String string = returnVal.get("result").get("release-codename").asString();
            }
            catch (Exception e) {
                logger.error("It was not possible to open connection to Wildfly/EAP server.", (Throwable)e);
                throw new Exception("It was not possible to open connection to server. " + e.getMessage());
            }
        }
        return client;
    }

    public void checkResponse(ModelNode response) throws Exception {
        String outcome;
        String string = outcome = response.get("outcome") != null ? response.get("outcome").asString() : "";
        if (outcome.contains("failed")) {
            throw new Exception("operation execution failed. :" + this.getErrorDescription(response));
        }
        if (outcome.contains("canceled")) {
            throw new Exception("operation execution was canceled by server: " + this.getErrorDescription(response));
        }
        if (outcome.contains("success")) {
            // empty if block
        }
    }

    public boolean isFailure(ModelNode response) {
        String outcome = response.get("outcome") != null ? response.get("outcome").asString() : "";
        return outcome.contains("failed");
    }

    public void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                boolean disableClose;
                if (logger.isDebugEnabled()) {
                    logger.debug("starting ModelControllerClient connection close");
                }
                if (disableClose = Boolean.valueOf(System.getProperty("disableClose")).booleanValue()) {
                    logger.warn("ModelControllerClient connection closing was disabled");
                } else {
                    closeable.close();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ModelControllerClient connection was closed successfully");
                }
            }
            catch (Exception e) {
                logger.error("An error was produced during ModelControllerClient closing: ", (Throwable)e);
            }
        }
    }

    private String getErrorDescription(ModelNode response) {
        if (response.hasDefined("failure-description")) {
            return response.get("failure-description").asString();
        }
        return response.asString();
    }
}

