/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyBaseClient;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDataSourceDef;

public class WildflyDataSourceManagementClient
extends WildflyBaseClient {
    public void createDataSource(WildflyDataSourceDef dataSourceDef) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "datasources");
        if (dataSourceDef.getName() != null) {
            operation.get("address").add("data-source", dataSourceDef.getName());
        }
        if (dataSourceDef.getJndi() != null) {
            operation.get("jndi-name").set(dataSourceDef.getJndi());
        }
        if (dataSourceDef.getConnectionURL() != null) {
            operation.get("connection-url").set(dataSourceDef.getConnectionURL());
        }
        if (dataSourceDef.getDriverName() != null) {
            operation.get("driver-name").set(dataSourceDef.getDriverName());
        }
        if (dataSourceDef.getDriverClass() != null) {
            operation.get("driver-class").set(dataSourceDef.getDriverClass());
        }
        if (dataSourceDef.getDataSourceClass() != null) {
            operation.get("datasource-class").set(dataSourceDef.getDataSourceClass());
        }
        if (dataSourceDef.getUser() != null) {
            operation.get("user-name").set(dataSourceDef.getUser());
        }
        if (dataSourceDef.getPassword() != null) {
            operation.get("password").set(dataSourceDef.getPassword());
        }
        operation.get("jta").set(dataSourceDef.isUseJTA());
        operation.get("use-ccm").set(dataSourceDef.isUseCCM());
        ModelControllerClient client = this.createControllerClient();
        ModelNode response = client.execute(new OperationBuilder(operation).build());
        this.safeClose((Closeable)client);
        this.checkResponse(response);
    }

    public void updateDataSource(WildflyDataSourceDef dataSourceDef) throws Exception {
        HashMap<String, Object> changeSet = new HashMap<String, Object>();
        changeSet.put("jndi-name", dataSourceDef.getJndi());
        changeSet.put("connection-url", dataSourceDef.getConnectionURL());
        changeSet.put("driver-class", dataSourceDef.getDriverClass());
        changeSet.put("datasource-class", dataSourceDef.getDataSourceClass());
        changeSet.put("driver-name", dataSourceDef.getDriverName());
        changeSet.put("user-name", dataSourceDef.getUser());
        changeSet.put("password", dataSourceDef.getPassword());
        this.updateDatasource(dataSourceDef.getName(), changeSet);
    }

    private void updateDatasource(String name, Map<String, Object> changeSet) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("composite");
        operation.get("address").setEmptyList();
        ModelNode stepTemplate = new ModelNode();
        stepTemplate.get("operation").set("write-attribute");
        stepTemplate.get("address").add("subsystem", "datasources");
        stepTemplate.get("address").add("data-source", name);
        ArrayList<ModelNode> steps = new ArrayList<ModelNode>();
        for (String attrName : changeSet.keySet()) {
            Object value = changeSet.get(attrName);
            if (value == null) continue;
            ModelNode step = stepTemplate.clone();
            step.get("name").set(attrName);
            ModelNode stepValue = step.get("value");
            stepValue.set(value.toString());
            steps.add(step);
        }
        operation.get("steps").set(steps);
        ModelControllerClient client = this.createControllerClient();
        ModelNode response = client.execute(new OperationBuilder(operation).build());
        this.safeClose((Closeable)client);
        this.checkResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WildflyDataSourceDef> getDataSources() throws Exception {
        ArrayList<WildflyDataSourceDef> dataSources = new ArrayList<WildflyDataSourceDef>();
        ModelNode response = null;
        ModelControllerClient client = null;
        try {
            client = this.createControllerClient();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-children-resources");
            operation.get("child-type").set("data-source");
            operation.get("address").add("subsystem", "datasources");
            response = client.execute(new OperationBuilder(operation).build());
            if (!this.isFailure(response) && response.hasDefined("result")) {
                List nodes = response.get("result").asList();
                for (ModelNode resultNode : nodes) {
                    Property property = resultNode.asProperty();
                    ModelNode node = property.getValue();
                    WildflyDataSourceDef dataSource = new WildflyDataSourceDef();
                    dataSource.setName(property.getName());
                    dataSource.setJndi(node.get("jndi-name").asString());
                    dataSource.setConnectionURL(node.get("connection-url").asString());
                    dataSource.setDriverName(node.get("driver-name").asString());
                    dataSource.setDriverClass(node.get("driver-class").asString());
                    dataSource.setDataSourceClass(node.get("datasource-class").asString());
                    dataSource.setUser(node.get("user-name").asString());
                    dataSource.setPassword(node.get("password").asString());
                    dataSource.setUseJTA(node.get("jta").asBoolean());
                    dataSource.setUseCCM(node.get("use-ccm").asBoolean());
                    dataSources.add(dataSource);
                }
            }
        }
        catch (Throwable throwable) {
            this.safeClose((Closeable)client);
            this.checkResponse(response);
            throw throwable;
        }
        this.safeClose((Closeable)client);
        this.checkResponse(response);
        return dataSources;
    }

    public void enableDataSource(String name, boolean enable) throws Exception {
        String opName = enable ? "enable" : "disable";
        ModelNode operation = new ModelNode();
        operation.get("operation").set(opName);
        operation.get("address").add("subsystem", "datasources");
        operation.get("address").add("data-source", name);
        if (!enable) {
            operation.get("operation-headers").get("allow-resource-service-restart").set(true);
        }
        ModelControllerClient client = this.createControllerClient();
        ModelNode result = client.execute(operation);
        this.safeClose((Closeable)client);
        this.checkResponse(result);
    }

    public void deleteDataSource(String name) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").add("subsystem", "datasources");
        operation.get("address").add("data-source", name);
        ModelControllerClient client = this.createControllerClient();
        ModelNode result = client.execute(operation);
        this.safeClose((Closeable)client);
        this.checkResponse(result);
    }
}

