/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.wildfly;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;

public class DeploymentIdGenerator {
    private static final String SEPARATOR = "#";
    private static final Pattern KIE_GENERATED_ID = Pattern.compile("kie#([^#]+)#(.*)");
    private static final Pattern KIE_ID = Pattern.compile("kie#([^#]+)#");

    public static String extractUuid(String deploymentId) throws Exception {
        String[] parts;
        Matcher matcher;
        if (deploymentId != null && DeploymentIdGenerator.isKieGenerated(deploymentId) && (matcher = KIE_ID.matcher(deploymentId)).find() && (parts = matcher.group().split(SEPARATOR)).length > 1) {
            return parts[1];
        }
        throw new Exception("Unknown deployment identifier." + deploymentId);
    }

    public static String generateDeploymentId(DriverDef driverDef) {
        return DeploymentIdGenerator.generateDeploymentId(driverDef.getUuid());
    }

    public static String generateDeploymentId(DataSourceDef dataSourceDef) {
        return DeploymentIdGenerator.generateDeploymentId(dataSourceDef.getUuid());
    }

    public static String generateDeploymentId(String uuid) {
        return "kie#" + uuid + SEPARATOR;
    }

    private static final boolean isKieGenerated(String value) {
        return KIE_GENERATED_ID.matcher(value).matches();
    }
}

