/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.validation;

import java.util.Optional;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

public abstract class ExampleProjectValidator {
    public static final String POM_XML = "pom.xml";
    private Logger logger = LoggerFactory.getLogger(ExampleProjectValidator.class);

    public Optional<ExampleProjectError> validate(ExampleProject exampleProject) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validation project [{}]", (Object)exampleProject.getName());
        }
        Path rootPath = exampleProject.getRoot();
        Optional<ExampleProjectError> error = this.getError(rootPath);
        if (this.logger.isDebugEnabled() && error.isPresent()) {
            this.logger.debug("Error found [{} - {} - {}]", new Object[]{exampleProject.getName(), error.get().getId(), error.get().getDescription()});
        }
        return error;
    }

    protected abstract Optional<ExampleProjectError> getError(Path var1);

    protected POM getPom(POMService pomService, Path rootPath) {
        String rootPathUri = rootPath.toURI();
        String pomUri = POM_XML;
        if (!rootPathUri.endsWith("/")) {
            pomUri = "/" + pomUri;
        }
        Path pomPath = PathFactory.newPath((String)POM_XML, (String)(rootPathUri + pomUri));
        return (POM)pomService.load(pomPath);
    }
}

