/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExampleTargetRepository;
import org.kie.workbench.common.screens.examples.model.ExamplesMetaData;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class ExamplesServiceImpl
implements ExamplesService {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesServiceImpl.class);
    private static final String PROJECT_DESCRIPTON = "project.description";
    private IOService ioService;
    private ConfigurationFactory configurationFactory;
    private RepositoryFactory repositoryFactory;
    private KieProjectService projectService;
    private RepositoryService repositoryService;
    private OrganizationalUnitService ouService;
    private Event<NewProjectEvent> newProjectEvent;
    private SafeSessionInfo sessionInfo;
    private final Set<Repository> clonedRepositories = new HashSet<Repository>();
    private final Set<ExampleRepository> exampleRepositories = new HashSet<ExampleRepository>();

    public ExamplesServiceImpl() {
    }

    @Inject
    public ExamplesServiceImpl(@Named(value="ioStrategy") IOService ioService, ConfigurationFactory configurationFactory, RepositoryFactory repositoryFactory, KieProjectService projectService, RepositoryService repositoryService, OrganizationalUnitService ouService, Event<NewProjectEvent> newProjectEvent, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.configurationFactory = configurationFactory;
        this.repositoryFactory = repositoryFactory;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.ouService = ouService;
        this.newProjectEvent = newProjectEvent;
        this.sessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void loadExampleRepositoryDetails() {
        try {
            Properties repositoryProperties = new Properties();
            repositoryProperties.load(this.getClass().getResourceAsStream("/example-repositories.properties"));
            for (String key : repositoryProperties.stringPropertyNames()) {
                this.exampleRepositories.add(new ExampleRepository(repositoryProperties.getProperty(key)));
            }
        }
        catch (java.io.IOException e) {
            logger.error("Unable to load details of Example Repositories. None will be available in the Workbench.", (Throwable)e);
        }
    }

    public ExamplesMetaData getMetaData() {
        return new ExamplesMetaData(this.getExampleRepositories(), this.getExampleOrganizationalUnits());
    }

    Set<ExampleRepository> getExampleRepositories() {
        return this.exampleRepositories;
    }

    Set<ExampleOrganizationalUnit> getExampleOrganizationalUnits() {
        Collection organizationalUnits = this.ouService.getOrganizationalUnits();
        HashSet<ExampleOrganizationalUnit> exampleOrganizationalUnits = new HashSet<ExampleOrganizationalUnit>();
        for (OrganizationalUnit ou : organizationalUnits) {
            exampleOrganizationalUnits.add(new ExampleOrganizationalUnit(ou.getName()));
        }
        return exampleOrganizationalUnits;
    }

    public Set<ExampleProject> getProjects(ExampleRepository repository) {
        if (repository == null) {
            return Collections.emptySet();
        }
        String repositoryURL = repository.getUrl();
        if (repositoryURL == null || repositoryURL.trim().isEmpty()) {
            return Collections.emptySet();
        }
        Repository gitRepository = this.cloneRepository(repositoryURL);
        if (gitRepository == null) {
            return Collections.emptySet();
        }
        Set projects = this.projectService.getProjects(gitRepository, "master");
        return this.convert(projects);
    }

    private Repository cloneRepository(final String repositoryURL) {
        Repository repository = null;
        try {
            String alias = this.getExampleAlias(repositoryURL);
            HashMap<String, Object> env = new HashMap<String, Object>(){
                {
                    this.put("origin", repositoryURL);
                    this.put("scheme", "git");
                }
            };
            ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
            for (Map.Entry entry : env.entrySet()) {
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem((String)entry.getKey(), entry.getValue()));
            }
            repository = this.repositoryFactory.newRepository(repositoryConfig);
            this.clonedRepositories.add(repository);
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getExampleAlias(String repositoryURL) {
        String alias = repositoryURL;
        int lastDotIndex = (alias = alias.substring(alias.lastIndexOf(47) + 1)).lastIndexOf(46);
        if (lastDotIndex > 0) {
            alias = alias.substring(0, lastDotIndex);
        }
        return "examples-" + alias;
    }

    private Set<ExampleProject> convert(Set<Project> projects) {
        HashSet<ExampleProject> exampleProjects = new HashSet<ExampleProject>();
        for (Project project : projects) {
            exampleProjects.add(new ExampleProject(project.getRootPath(), project.getProjectName(), this.readDescription(project)));
        }
        return exampleProjects;
    }

    private String readDescription(Project project) {
        org.uberfire.backend.vfs.Path root = project.getRootPath();
        Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)root);
        Path nioDescription = nioRoot.resolve(PROJECT_DESCRIPTON);
        String description = "Example '" + project.getProjectName() + "' project";
        if (this.ioService.exists(nioDescription)) {
            description = this.ioService.readAllString(nioDescription);
        }
        return description;
    }

    public boolean validateRepositoryName(String name) {
        return this.repositoryService.validateRepositoryName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectContextChangeEvent setupExamples(ExampleOrganizationalUnit exampleTargetOU, ExampleTargetRepository exampleTarget, List<ExampleProject> exampleProjects) {
        String targetRepositoryAlias;
        Repository targetRepository;
        PortablePreconditions.checkNotNull((String)"exampleTargetOU", (Object)exampleTargetOU);
        PortablePreconditions.checkNotNull((String)"exampleTarget", (Object)exampleTarget);
        PortablePreconditions.checkNotNull((String)"exampleProjects", exampleProjects);
        PortablePreconditions.checkCondition((String)"Must have at least one ExampleProject", (exampleProjects.size() > 0 ? 1 : 0) != 0);
        String targetOUName = exampleTargetOU.getName();
        OrganizationalUnit targetOU = this.ouService.getOrganizationalUnit(targetOUName);
        if (targetOU == null) {
            targetOU = this.createOrganizationalUnit(targetOUName);
        }
        if ((targetRepository = this.repositoryService.getRepository(targetRepositoryAlias = exampleTarget.getAlias())) == null) {
            targetRepository = this.createTargetRepository(targetOU, targetRepositoryAlias);
        }
        org.uberfire.backend.vfs.Path targetRepositoryRoot = targetRepository.getRoot();
        Path nioTargetRepositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)targetRepositoryRoot);
        KieProject firstExampleProject = null;
        try {
            this.ioService.startBatch(nioTargetRepositoryRoot.getFileSystem());
            for (ExampleProject exampleProject : exampleProjects) {
                org.uberfire.backend.vfs.Path exampleProjectRoot = exampleProject.getRoot();
                Path nioExampleProjectRoot = Paths.convert((org.uberfire.backend.vfs.Path)exampleProjectRoot);
                Path nioTargetProjectRoot = nioTargetRepositoryRoot.resolve(exampleProject.getName());
                RecursiveCopier copier = new RecursiveCopier(nioExampleProjectRoot, nioTargetProjectRoot);
                Files.walkFileTree((Path)nioExampleProjectRoot, (FileVisitor)copier);
                org.uberfire.backend.vfs.Path targetProjectRoot = Paths.convert((Path)nioTargetProjectRoot);
                KieProject project = (KieProject)this.projectService.resolveProject(targetProjectRoot);
                this.newProjectEvent.fire((Object)new NewProjectEvent((Project)project, this.sessionInfo.getId(), this.sessionInfo.getIdentity().getIdentifier()));
                if (firstExampleProject != null) continue;
                firstExampleProject = project;
            }
        }
        catch (IOException ioe) {
            logger.error("Unable to create Example(s).", (Throwable)ioe);
        }
        finally {
            this.ioService.endBatch();
        }
        return new ProjectContextChangeEvent(targetOU, targetRepository, targetRepository.getDefaultBranch(), firstExampleProject);
    }

    private OrganizationalUnit createOrganizationalUnit(String name) {
        OrganizationalUnit ou = this.ouService.createOrganizationalUnit(name, "", "");
        return ou;
    }

    private Repository createTargetRepository(OrganizationalUnit ou, String alias) {
        RepositoryEnvironmentConfigurations configuration = new RepositoryEnvironmentConfigurations();
        configuration.setManaged(false);
        Repository repository = this.repositoryService.createRepository(ou, "git", alias, configuration);
        return repository;
    }

    public int priority() {
        return 0;
    }

    public void dispose() {
        for (Repository repository : this.clonedRepositories) {
            try {
                this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to remove transient Repository '" + repository.getAlias() + "'.", (Throwable)e);
            }
        }
    }

    static class RecursiveCopier
    implements FileVisitor<Path> {
        private final Path source;
        private final Path target;

        RecursiveCopier(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        public FileVisitResult preVisitDirectory(Path src, BasicFileAttributes attrs) {
            Path tgt = this.target.resolve(this.source.relativize(src));
            try {
                Files.copy((Path)src, (Path)tgt, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

