/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.backend.server.BaseProjectImportService;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExamplesMetaData;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidators;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;

@Service
@ApplicationScoped
public class ExamplesServiceImpl
extends BaseProjectImportService
implements ExamplesService {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesServiceImpl.class);
    private static final String KIE_WB_PLAYGROUND_ZIP = "org/kie/kie-wb-playground/kie-wb-playground.zip";
    private final Set<Repository> clonedRepositories = new HashSet<Repository>();
    private WorkspaceProjectService projectService;
    private IOService ioService;
    private ConfigurationFactory configurationFactory;
    private RepositoryFactory repositoryFactory;
    private KieModuleService moduleService;
    private RepositoryCopier repositoryCopier;
    private OrganizationalUnitService ouService;
    private Event<NewProjectEvent> newProjectEvent;
    private MetadataService metadataService;
    private ExampleRepository playgroundRepository;
    private ProjectScreenService projectScreenService;
    private ImportProjectValidators validators;

    @Inject
    public ExamplesServiceImpl(@Named(value="ioStrategy") IOService ioService, ConfigurationFactory configurationFactory, RepositoryFactory repositoryFactory, KieModuleService moduleService, RepositoryCopier repositoryCopier, OrganizationalUnitService ouService, WorkspaceProjectService projectService, MetadataService metadataService, Event<NewProjectEvent> newProjectEvent, ProjectScreenService projectScreenService, ImportProjectValidators validators) {
        super(ioService, metadataService, validators, configurationFactory, moduleService, projectService, projectScreenService);
        this.ioService = ioService;
        this.configurationFactory = configurationFactory;
        this.repositoryFactory = repositoryFactory;
        this.moduleService = moduleService;
        this.repositoryCopier = repositoryCopier;
        this.ouService = ouService;
        this.projectService = projectService;
        this.metadataService = metadataService;
        this.newProjectEvent = newProjectEvent;
        this.projectScreenService = projectScreenService;
        this.validators = validators;
    }

    @PostConstruct
    public void initPlaygroundRepository() {
        try {
            String userDir = System.getProperty("user.dir");
            File playgroundDirectory = new File(userDir, ".kie-wb-playground");
            if (playgroundDirectory.exists()) {
                this.cleanPlaygroundDirectory(playgroundDirectory.toPath());
            }
            playgroundDirectory.mkdirs();
            URL resource = this.getClass().getClassLoader().getResource(KIE_WB_PLAYGROUND_ZIP);
            if (resource == null) {
                logger.warn("Playground repository jar not found on classpath.");
                return;
            }
            try (ZipInputStream inputStream = new ZipInputStream(resource.openStream());){
                ZipEntry zipEntry = null;
                while ((zipEntry = inputStream.getNextEntry()) != null) {
                    byte[] buffer = new byte[1024];
                    File file = new File(playgroundDirectory, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        int read = -1;
                        while ((read = inputStream.read(buffer)) != -1) {
                            fos.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                Git git = Git.init().setBare(false).setDirectory(playgroundDirectory).call();
                git.add().addFilepattern(".").call();
                git.commit().setMessage("Initial commit").call();
                String repositoryUrl = this.resolveRepositoryUrl(playgroundDirectory.getAbsolutePath());
                this.playgroundRepository = new ExampleRepository(repositoryUrl);
            }
        }
        catch (java.io.IOException | GitAPIException e) {
            logger.error("Unable to initialize playground git repository. Only custom repository definition will be available in the Workbench.", e);
        }
    }

    private void cleanPlaygroundDirectory(Path playgroundDirectoryPath) throws java.io.IOException {
        Files.walkFileTree(playgroundDirectoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws java.io.IOException {
                file.toFile().delete();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, java.io.IOException exc) throws java.io.IOException {
                dir.toFile().delete();
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected String resolveRepositoryUrl(String playgroundDirectoryPath) {
        if ("\\".equals(this.getFileSeparator())) {
            return "file:///" + playgroundDirectoryPath.replaceAll("\\\\", "/");
        }
        return "file://" + playgroundDirectoryPath;
    }

    public ExamplesMetaData getMetaData() {
        return new ExamplesMetaData(this.getPlaygroundRepository());
    }

    public ExampleRepository getPlaygroundRepository() {
        return this.playgroundRepository;
    }

    @Override
    protected Repository resolveGitRepository(ExampleRepository exampleRepository) {
        if (exampleRepository.equals((Object)this.playgroundRepository)) {
            return this.clonedRepositories.stream().filter(r -> exampleRepository.getUrl().equals(r.getEnvironment().get("origin"))).findFirst().orElseGet(() -> this.cloneRepository(exampleRepository.getUrl()));
        }
        Credentials credentials = exampleRepository.getCredentials();
        String username = null;
        String password = null;
        if (credentials != null) {
            username = credentials.getUsername();
            password = credentials.getPassword();
        }
        return this.cloneRepository(exampleRepository.getUrl(), username, password);
    }

    private Repository cloneRepository(String repositoryURL) {
        return this.cloneRepository(repositoryURL, null, null);
    }

    private Repository cloneRepository(String repositoryURL, String userName, String password) {
        try {
            String alias = this.getRepositoryAlias(repositoryURL);
            Map<String, Object> env = this.buildGitEnv(repositoryURL, userName, password, false);
            ConfigGroup repositoryConfig = this.createConfigGroup(alias, env);
            Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
            this.clonedRepositories.add(repository);
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getRepositoryAlias(String repositoryURL) {
        return "examples-" + super.getRepositoryAlias(repositoryURL);
    }

    String getFileSeparator() {
        return FileSystems.getDefault().getSeparator();
    }

    public WorkspaceProjectContextChangeEvent setupExamples(ExampleOrganizationalUnit exampleTargetOU, List<ImportProject> importProjects) {
        PortablePreconditions.checkNotNull((String)"exampleTargetOU", (Object)exampleTargetOU);
        PortablePreconditions.checkNotNull((String)"exampleProjects", importProjects);
        PortablePreconditions.checkCondition((String)"Must have at least one ExampleProject", (importProjects.size() > 0 ? 1 : 0) != 0);
        String targetOUName = exampleTargetOU.getName();
        OrganizationalUnit targetOU = this.getOrganizationalUnit(targetOUName);
        return this.importProjects(targetOU, importProjects);
    }

    public Set<ImportProject> getExampleProjects() {
        ExampleRepository repos = this.getPlaygroundRepository();
        return this.getProjects(repos);
    }

    protected OrganizationalUnit getOrganizationalUnit(String targetOUName) {
        OrganizationalUnit targetOU = this.ouService.getOrganizationalUnit(targetOUName);
        if (targetOU == null) {
            targetOU = this.createOrganizationalUnit(targetOUName);
        }
        return targetOU;
    }

    protected OrganizationalUnit createOrganizationalUnit(String name) {
        OrganizationalUnit ou = this.ouService.createOrganizationalUnit(name, "", "");
        return ou;
    }

    public int priority() {
        return 0;
    }

    public void dispose() {
        for (Repository repository : this.clonedRepositories) {
            try {
                if (!repository.getDefaultBranch().isPresent()) continue;
                this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)((Branch)repository.getDefaultBranch().get()).getPath()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to remove transient Repository '" + repository.getAlias() + "'.", (Throwable)e);
            }
        }
    }

    Set<Repository> getClonedRepositories() {
        return this.clonedRepositories;
    }

    void setPlaygroundRepository(ExampleRepository playgroundRepository) {
        this.playgroundRepository = playgroundRepository;
    }

    protected WorkspaceProjectContextChangeEvent importProjects(OrganizationalUnit targetOU, List<ImportProject> projects) {
        WorkspaceProject firstExampleProject = null;
        for (ImportProject importProject : projects) {
            try {
                Repository targetRepository = this.repositoryCopier.copy(targetOU, "example-" + importProject.getName(), importProject.getRoot());
                WorkspaceProject project = this.projectService.resolveProject(targetRepository);
                project = this.renameIfNecessary(targetOU, project);
                this.newProjectEvent.fire((Object)new NewProjectEvent(project));
                if (firstExampleProject != null) continue;
                firstExampleProject = project;
            }
            catch (IOException ioe) {
                logger.error("Unable to create Example(s).", (Throwable)ioe);
            }
        }
        return new WorkspaceProjectContextChangeEvent(firstExampleProject, firstExampleProject.getMainModule());
    }
}

