/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.screens.examples.backend.server.ExamplesPreferencesLoader;

public class ExamplesPreferencesLoaderTest {
    private String oldPropertyValue;
    private ExamplesPreferencesLoader loader;

    @Before
    public void setup() {
        this.oldPropertyValue = System.getProperty("org.kie.demo");
        this.loader = new ExamplesPreferencesLoader();
    }

    @After
    public void reset() {
        if (this.oldPropertyValue != null) {
            System.setProperty("org.kie.demo", this.oldPropertyValue);
        } else {
            System.clearProperty("org.kie.demo");
        }
    }

    @Test
    public void testWithoutSystemProperty() {
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)results.get("org.kie.demo")));
    }

    @Test
    public void testWithSystemPropertyTrue() {
        System.setProperty("org.kie.demo", "true");
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)results.get("org.kie.demo")));
    }

    @Test
    public void testWithSystemPropertyFalse() {
        System.setProperty("org.kie.demo", "false");
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertFalse((boolean)Boolean.parseBoolean((String)results.get("org.kie.demo")));
    }

    @Test
    public void testWithSystemPropertyDuffValue() {
        System.setProperty("org.kie.demo", "cheese");
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertFalse((boolean)Boolean.parseBoolean((String)results.get("org.kie.demo")));
    }
}

