/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.backend.server.ExamplesServiceImpl;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.validation.ExampleProjectValidators;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ExamplesServiceImplRepositoryNamesTest {
    @Mock
    private IOService ioService;
    @Mock
    private ConfigurationFactory configurationFactory;
    @Mock
    private RepositoryFactory repositoryFactory;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private RepositoryCopier repositoryCopier;
    @Mock
    private OrganizationalUnitService ouService;
    @Mock
    private MetadataService metadataService;
    @Spy
    private Event<NewProjectEvent> newProjectEvent = new EventSourceMock<NewProjectEvent>(){

        public void fire(NewProjectEvent event) {
        }
    };
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private User user;
    @Mock
    private WorkspaceProjectService projectService;
    @Mock
    private ProjectScreenService projectScreenService;
    private ExamplesServiceImpl service;
    @Mock
    private ExampleOrganizationalUnit exampleOrganizationalUnit;
    private List<ExampleProject> exampleProjects;
    @Captor
    private ArgumentCaptor<ProjectScreenModel> modelCapture;
    @Mock
    private ExampleProjectValidators validators;

    @Before
    public void setup() {
        this.service = (ExamplesServiceImpl)Mockito.spy((Object)new ExamplesServiceImpl(this.ioService, this.configurationFactory, this.repositoryFactory, this.moduleService, this.repositoryCopier, this.ouService, this.projectService, this.metadataService, this.newProjectEvent, this.projectScreenService, this.validators));
        Mockito.when((Object)this.validators.getValidators()).thenReturn(new ArrayList());
        Mockito.when((Object)this.ouService.getOrganizationalUnits()).thenReturn((Object)new HashSet<OrganizationalUnit>(){
            {
                this.add(new OrganizationalUnitImpl("ou1Name", "ou1Owner", "ou1GroupId"));
            }
        });
        Mockito.when((Object)this.moduleService.resolveModule((Path)Matchers.any(Path.class))).thenAnswer((Answer)new Answer<KieModule>(){

            public KieModule answer(InvocationOnMock invocationOnMock) throws Throwable {
                Path path = (Path)invocationOnMock.getArguments()[0];
                KieModule module = new KieModule(path, path, path, path, path, path, (POM)Mockito.mock(POM.class));
                return module;
            }
        });
        Mockito.when((Object)this.sessionInfo.getId()).thenReturn((Object)"sessionId");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user");
        Mockito.when((Object)this.configurationFactory.newConfigGroup((ConfigType)Matchers.any(ConfigType.class), Matchers.anyString(), Matchers.anyString())).thenReturn(Mockito.mock(ConfigGroup.class));
        final ExampleProject exProject1 = (ExampleProject)Mockito.mock(ExampleProject.class);
        this.exampleProjects = new ArrayList<ExampleProject>(){
            {
                this.add(exProject1);
            }
        };
        OrganizationalUnit ou = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"ou").when((Object)ou)).getName();
        GitRepository repository1 = (GitRepository)Mockito.mock(GitRepository.class);
        Path repositoryRoot = (Path)Mockito.mock(Path.class);
        Path module1Root = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.exampleOrganizationalUnit.getName()).thenReturn((Object)"ou");
        Mockito.when((Object)exProject1.getName()).thenReturn((Object)"module1");
        Mockito.when((Object)exProject1.getRoot()).thenReturn((Object)module1Root);
        Mockito.when((Object)repository1.getBranch("dev_branch")).thenReturn(Optional.of(new Branch("dev_branch", repositoryRoot)));
        Optional<Branch> master = Optional.of(new Branch("master", PathFactory.newPath((String)"testFile", (String)"file:///")));
        Mockito.when((Object)repository1.getDefaultBranch()).thenReturn(master);
        Mockito.when((Object)repositoryRoot.toURI()).thenReturn((Object)"default:///");
        Mockito.when((Object)module1Root.toURI()).thenReturn((Object)"default:///module1");
        Mockito.when((Object)this.ouService.getOrganizationalUnit((String)Matchers.eq((Object)"ou"))).thenReturn((Object)ou);
        ((GitRepository)Mockito.doReturn((Object)"module1").when((Object)repository1)).getAlias();
        ((RepositoryCopier)Mockito.doReturn((Object)repository1).when((Object)this.repositoryCopier)).copy((OrganizationalUnit)Matchers.eq((Object)ou), Matchers.anyString(), (Path)Matchers.eq((Object)module1Root));
        WorkspaceProject project = (WorkspaceProject)Mockito.spy((Object)new WorkspaceProject());
        ((WorkspaceProject)Mockito.doReturn((Object)repository1.getAlias()).when((Object)project)).getName();
        ((WorkspaceProject)Mockito.doReturn((Object)Mockito.mock(Module.class)).when((Object)project)).getMainModule();
        ((WorkspaceProject)Mockito.doReturn((Object)Mockito.mock(OrganizationalUnit.class)).when((Object)project)).getOrganizationalUnit();
        ((WorkspaceProjectService)Mockito.doReturn((Object)project).when((Object)this.projectService)).resolveProject((Repository)repository1);
        ((WorkspaceProjectService)Mockito.doReturn((Object)project).when((Object)this.projectService)).resolveProject((Path)Matchers.any(Path.class));
        ProjectScreenModel model = new ProjectScreenModel();
        model.setPOM(new POM());
        ((ProjectScreenService)Mockito.doReturn((Object)model).when((Object)this.projectScreenService)).load((Path)Matchers.any());
    }

    @Test
    public void nameIsNotTaken() {
        this.service.setupExamples(this.exampleOrganizationalUnit, this.exampleProjects);
        ((RepositoryCopier)Mockito.verify((Object)this.repositoryCopier)).copy((OrganizationalUnit)Matchers.any(OrganizationalUnit.class), (String)Matchers.eq((Object)"module1"), (Path)Matchers.any(Path.class));
        ((ProjectScreenService)Mockito.verify((Object)this.projectScreenService, (VerificationMode)Mockito.never())).save((Path)Matchers.any(), (ProjectScreenModel)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void nameIsTaken() {
        String module1 = "module1";
        String module1_1 = "module1 [1]";
        WorkspaceProject project1 = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ((WorkspaceProject)Mockito.doReturn((Object)module1).when((Object)project1)).getName();
        ArrayList<WorkspaceProject> projects = new ArrayList<WorkspaceProject>();
        projects.add(project1);
        projects.add(project1);
        ((WorkspaceProjectService)Mockito.doReturn(projects).when((Object)this.projectService)).getAllWorkspaceProjectsByName((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)module1));
        ((WorkspaceProjectService)Mockito.doReturn((Object)module1_1).when((Object)this.projectService)).createFreshProjectName((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)module1));
        this.service.setupExamples(this.exampleOrganizationalUnit, this.exampleProjects);
        ((ProjectScreenService)Mockito.verify((Object)this.projectScreenService)).save((Path)Matchers.any(), (ProjectScreenModel)this.modelCapture.capture(), (String)Matchers.any());
        ProjectScreenModel model = (ProjectScreenModel)this.modelCapture.getValue();
        Assert.assertEquals((Object)module1_1, (Object)model.getPOM().getName());
    }

    @Test
    public void evenTheSecundaryNameIsTaken() {
        String module = "module1";
        String module_1 = "module1 [1]";
        String module_2 = "module1 [2]";
        ((WorkspaceProjectService)Mockito.doReturn((Object)module_2).when((Object)this.projectService)).createFreshProjectName((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)module));
        WorkspaceProject project1 = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ((WorkspaceProject)Mockito.doReturn((Object)module).when((Object)project1)).getName();
        ArrayList<WorkspaceProject> projects1 = new ArrayList<WorkspaceProject>();
        projects1.add(project1);
        projects1.add(project1);
        ((WorkspaceProjectService)Mockito.doReturn(projects1).when((Object)this.projectService)).getAllWorkspaceProjectsByName((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)module));
        WorkspaceProject project2 = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ((WorkspaceProject)Mockito.doReturn((Object)module_1).when((Object)project2)).getName();
        ArrayList<WorkspaceProject> projects2 = new ArrayList<WorkspaceProject>();
        projects2.add(project2);
        ((WorkspaceProjectService)Mockito.doReturn(projects2).when((Object)this.projectService)).getAllWorkspaceProjectsByName((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)module_1));
        this.service.setupExamples(this.exampleOrganizationalUnit, this.exampleProjects);
        ((ProjectScreenService)Mockito.verify((Object)this.projectScreenService)).save((Path)Matchers.any(), (ProjectScreenModel)this.modelCapture.capture(), (String)Matchers.any());
        ProjectScreenModel model = (ProjectScreenModel)this.modelCapture.getValue();
        Assert.assertEquals((Object)module_2, (Object)model.getPOM().getName());
    }
}

