/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.backend.server.ExamplesServiceImpl;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExamplesMetaData;
import org.kie.workbench.common.screens.examples.validation.ExampleProjectValidators;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class ExamplesServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private ConfigurationFactoryImpl configurationFactory;
    @Mock
    private RepositoryFactory repositoryFactory;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private RepositoryCopier repositoryCopier;
    @Mock
    private OrganizationalUnitService ouService;
    @Mock
    private MetadataService metadataService;
    @Spy
    private Event<NewProjectEvent> newProjectEvent = new EventSourceMock<NewProjectEvent>(){

        public void fire(NewProjectEvent event) {
        }
    };
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private User user;
    @Mock
    private WorkspaceProjectService projectService;
    @Mock
    private ProjectScreenService projectScreenService;
    @Mock
    private ExampleProjectValidators validators;
    private ExamplesServiceImpl service;

    @Before
    public void setup() {
        this.service = (ExamplesServiceImpl)Mockito.spy((Object)new ExamplesServiceImpl(this.ioService, (ConfigurationFactory)this.configurationFactory, this.repositoryFactory, this.moduleService, this.repositoryCopier, this.ouService, this.projectService, this.metadataService, this.newProjectEvent, this.projectScreenService, this.validators));
        Mockito.when((Object)this.validators.getValidators()).thenReturn(new ArrayList());
        Mockito.when((Object)this.ouService.getOrganizationalUnits()).thenReturn((Object)new HashSet<OrganizationalUnit>(){
            {
                this.add(new OrganizationalUnitImpl("ou1Name", "ou1Owner", "ou1GroupId"));
                this.add(new OrganizationalUnitImpl("ou2Name", "ou2Owner", "ou2GroupId"));
            }
        });
        Mockito.when((Object)this.moduleService.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenAnswer((Answer)new Answer<KieModule>(){

            public KieModule answer(InvocationOnMock invocationOnMock) throws Throwable {
                org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)invocationOnMock.getArguments()[0];
                KieModule module = new KieModule(path, path, path, path, path, path, (POM)Mockito.mock(POM.class));
                return module;
            }
        });
        Mockito.when((Object)this.sessionInfo.getId()).thenReturn((Object)"sessionId");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user");
        Mockito.when((Object)this.configurationFactory.newConfigGroup((ConfigType)Matchers.any(ConfigType.class), Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn(Mockito.mock(ConfigGroup.class));
    }

    @Test
    public void initPlaygroundRepository() {
        this.service.initPlaygroundRepository();
        ExampleRepository exampleRepository = this.service.getPlaygroundRepository();
        Assert.assertNotNull((Object)exampleRepository);
    }

    @Test
    public void testGetMetaData() {
        this.service.initPlaygroundRepository();
        ExamplesMetaData metaData = this.service.getMetaData();
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((Object)metaData.getRepository());
        Assert.assertNotNull((Object)metaData.getRepository().getUrl());
    }

    @Test
    public void testGetProjects_NullRepository() {
        Set modules = this.service.getProjects(null);
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)0L, (long)modules.size());
    }

    @Test
    public void testGetProjects_NullRepositoryUrl() {
        Set modules = this.service.getProjects(new ExampleRepository(null));
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)0L, (long)modules.size());
    }

    @Test
    public void testGetProjects_EmptyRepositoryUrl() {
        Set modules = this.service.getProjects(new ExampleRepository(""));
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)0L, (long)modules.size());
    }

    @Test
    public void testGetProjects_WhiteSpaceRepositoryUrl() {
        Set modules = this.service.getProjects(new ExampleRepository("   "));
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)0L, (long)modules.size());
    }

    @Test
    public void testGetProjects_DefaultDescription() {
        org.uberfire.backend.vfs.Path moduleRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        final KieModule module = (KieModule)Mockito.mock(KieModule.class);
        Mockito.when((Object)module.getRootPath()).thenReturn((Object)moduleRoot);
        Mockito.when((Object)module.getModuleName()).thenReturn((Object)"module1");
        Mockito.when((Object)moduleRoot.toURI()).thenReturn((Object)"default:///module1");
        Mockito.when((Object)this.metadataService.getTags((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn(Arrays.asList("tag1", "tag2"));
        GitRepository repository = this.makeGitRepository();
        Mockito.when((Object)this.repositoryFactory.newRepository((ConfigGroup)Matchers.any(ConfigGroup.class))).thenReturn((Object)repository);
        Mockito.when((Object)this.moduleService.getAllModules((Branch)Matchers.any(Branch.class))).thenReturn((Object)new HashSet<Module>(){
            {
                this.add(module);
            }
        });
        this.service.setPlaygroundRepository((ExampleRepository)Mockito.mock(ExampleRepository.class));
        Set modules = this.service.getProjects(new ExampleRepository("https://github.com/guvnorngtestuser1/guvnorng-playground.git"));
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)1L, (long)modules.size());
        Assert.assertTrue((boolean)modules.contains(new ExampleProject(moduleRoot, "module1", "Example 'module1' module", Arrays.asList("tag1", "tag2"))));
    }

    @Test
    public void testGetProjects_CustomDescription() {
        org.uberfire.backend.vfs.Path moduleRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        final KieModule module = (KieModule)Mockito.mock(KieModule.class);
        Mockito.when((Object)module.getRootPath()).thenReturn((Object)moduleRoot);
        Mockito.when((Object)module.getModuleName()).thenReturn((Object)"module1");
        Mockito.when((Object)moduleRoot.toURI()).thenReturn((Object)"default:///module1");
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"This is custom description.\n\n This is a new line.");
        Mockito.when((Object)this.metadataService.getTags((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn(Arrays.asList("tag1", "tag2"));
        GitRepository repository = this.makeGitRepository();
        Mockito.when((Object)this.repositoryFactory.newRepository((ConfigGroup)Matchers.any(ConfigGroup.class))).thenReturn((Object)repository);
        Mockito.when((Object)this.moduleService.getAllModules((Branch)Matchers.any(Branch.class))).thenReturn((Object)new HashSet<Module>(){
            {
                this.add(module);
            }
        });
        Set modules = this.service.getProjects(new ExampleRepository("https://github.com/guvnorngtestuser1/guvnorng-playground.git"));
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)1L, (long)modules.size());
        Assert.assertTrue((boolean)modules.contains(new ExampleProject(moduleRoot, "module1", "This is custom description. This is a new line.", Arrays.asList("tag1", "tag2"))));
    }

    @Test
    public void testGetProjects_PomDescription() {
        org.uberfire.backend.vfs.Path moduleRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        POM pom = (POM)Mockito.mock(POM.class);
        final KieModule module = (KieModule)Mockito.mock(KieModule.class);
        Mockito.when((Object)pom.getDescription()).thenReturn((Object)"pom description");
        Mockito.when((Object)module.getRootPath()).thenReturn((Object)moduleRoot);
        Mockito.when((Object)module.getModuleName()).thenReturn((Object)"module1");
        Mockito.when((Object)module.getPom()).thenReturn((Object)pom);
        Mockito.when((Object)moduleRoot.toURI()).thenReturn((Object)"default:///module1");
        Mockito.when((Object)this.metadataService.getTags((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn(Arrays.asList("tag1", "tag2"));
        GitRepository repository = this.makeGitRepository();
        Mockito.when((Object)this.repositoryFactory.newRepository((ConfigGroup)Matchers.any(ConfigGroup.class))).thenReturn((Object)repository);
        Mockito.when((Object)this.moduleService.getAllModules((Branch)Matchers.any(Branch.class))).thenReturn((Object)new HashSet<Module>(){
            {
                this.add(module);
            }
        });
        Set modules = this.service.getProjects(new ExampleRepository("https://github.com/guvnorngtestuser1/guvnorng-playground.git"));
        Assert.assertNotNull((Object)modules);
        Assert.assertEquals((long)1L, (long)modules.size());
        Assert.assertTrue((boolean)modules.contains(new ExampleProject(moduleRoot, "module1", "pom description", Arrays.asList("tag1", "tag2"))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetupExamples_NullOrganizationalUnit() {
        this.service.setupExamples(null, (List)Mockito.mock(List.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetupExamples_NullModule() {
        this.service.setupExamples((ExampleOrganizationalUnit)Mockito.mock(ExampleOrganizationalUnit.class), null);
    }

    @Test(expected=IllegalStateException.class)
    public void testSetupExamples_ZeroModules() {
        this.service.setupExamples((ExampleOrganizationalUnit)Mockito.mock(ExampleOrganizationalUnit.class), Collections.emptyList());
    }

    @Test
    public void testSetupExamples_NewOrganizationalUnitNewRepository() {
        ExampleOrganizationalUnit exOU = (ExampleOrganizationalUnit)Mockito.mock(ExampleOrganizationalUnit.class);
        final ExampleProject exModule = (ExampleProject)Mockito.mock(ExampleProject.class);
        ((ExampleProject)Mockito.doReturn((Object)"module").when((Object)exModule)).getName();
        ArrayList<ExampleProject> exModules = new ArrayList<ExampleProject>(){
            {
                this.add(exModule);
            }
        };
        OrganizationalUnit ou = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"ou").when((Object)ou)).getName();
        GitRepository repository = (GitRepository)Mockito.mock(GitRepository.class);
        org.uberfire.backend.vfs.Path repositoryRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path moduleRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)exOU.getName()).thenReturn((Object)"ou");
        Mockito.when((Object)exModule.getName()).thenReturn((Object)"module");
        Mockito.when((Object)exModule.getRoot()).thenReturn((Object)moduleRoot);
        Mockito.when((Object)repository.getDefaultBranch()).thenReturn(Optional.of(new Branch("master", repositoryRoot)));
        Mockito.when((Object)repositoryRoot.toURI()).thenReturn((Object)"default:///");
        Mockito.when((Object)moduleRoot.toURI()).thenReturn((Object)"default:///module");
        Mockito.when((Object)this.ouService.getOrganizationalUnit((String)Matchers.eq((Object)"ou"))).thenReturn(null);
        Mockito.when((Object)this.ouService.createOrganizationalUnit((String)Matchers.eq((Object)"ou"), (String)Matchers.eq((Object)""), (String)Matchers.eq((Object)""))).thenReturn((Object)ou);
        Mockito.when((Object)this.repositoryCopier.copy((OrganizationalUnit)Matchers.eq((Object)ou), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.eq((Object)moduleRoot))).thenReturn((Object)repository);
        WorkspaceProject project = (WorkspaceProject)Mockito.spy((Object)new WorkspaceProject());
        ((WorkspaceProject)Mockito.doReturn((Object)"project").when((Object)project)).getName();
        ((WorkspaceProjectService)Mockito.doReturn((Object)project).when((Object)this.projectService)).resolveProject((Repository)repository);
        WorkspaceProjectContextChangeEvent event = this.service.setupExamples(exOU, (List)exModules);
        Assert.assertNull((Object)event.getOrganizationalUnit());
        Assert.assertEquals((Object)project, (Object)event.getWorkspaceProject());
        ((OrganizationalUnitService)Mockito.verify((Object)this.ouService, (VerificationMode)Mockito.times((int)1))).createOrganizationalUnit((String)Matchers.eq((Object)"ou"), (String)Matchers.eq((Object)""), (String)Matchers.eq((Object)""));
        ((RepositoryCopier)Mockito.verify((Object)this.repositoryCopier, (VerificationMode)Mockito.times((int)1))).copy((OrganizationalUnit)Matchers.eq((Object)ou), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.eq((Object)moduleRoot));
        ((Event)Mockito.verify(this.newProjectEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NewProjectEvent.class));
    }

    @Test
    public void testSetupExamples_ProjectCopy() {
        ExampleOrganizationalUnit exOU = (ExampleOrganizationalUnit)Mockito.mock(ExampleOrganizationalUnit.class);
        final ExampleProject exProject1 = (ExampleProject)Mockito.mock(ExampleProject.class);
        ((ExampleProject)Mockito.doReturn((Object)"project 1").when((Object)exProject1)).getName();
        final ExampleProject exProject2 = (ExampleProject)Mockito.mock(ExampleProject.class);
        ((ExampleProject)Mockito.doReturn((Object)"project 2").when((Object)exProject1)).getName();
        ArrayList<ExampleProject> exProjects = new ArrayList<ExampleProject>(){
            {
                this.add(exProject1);
                this.add(exProject2);
            }
        };
        OrganizationalUnit ou = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"ou").when((Object)ou)).getName();
        GitRepository repository1 = (GitRepository)Mockito.mock(GitRepository.class);
        org.uberfire.backend.vfs.Path repositoryRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path module1Root = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path module2Root = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)exOU.getName()).thenReturn((Object)"ou");
        Mockito.when((Object)exProject1.getName()).thenReturn((Object)"module1");
        Mockito.when((Object)exProject1.getRoot()).thenReturn((Object)module1Root);
        Mockito.when((Object)exProject2.getName()).thenReturn((Object)"module2");
        Mockito.when((Object)exProject2.getRoot()).thenReturn((Object)module2Root);
        Mockito.when((Object)repository1.getBranch("dev_branch")).thenReturn(Optional.of(new Branch("dev_branch", repositoryRoot)));
        Optional<Branch> master = Optional.of(new Branch("master", PathFactory.newPath((String)"testFile", (String)"file:///")));
        Mockito.when((Object)repository1.getDefaultBranch()).thenReturn(master);
        Mockito.when((Object)repositoryRoot.toURI()).thenReturn((Object)"default:///");
        Mockito.when((Object)module1Root.toURI()).thenReturn((Object)"default:///module1");
        Mockito.when((Object)module2Root.toURI()).thenReturn((Object)"default:///module2");
        Mockito.when((Object)this.ouService.getOrganizationalUnit((String)Matchers.eq((Object)"ou"))).thenReturn((Object)ou);
        ((RepositoryCopier)Mockito.doReturn((Object)repository1).when((Object)this.repositoryCopier)).copy((OrganizationalUnit)Matchers.eq((Object)ou), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.eq((Object)module1Root));
        ((RepositoryCopier)Mockito.doReturn((Object)repository1).when((Object)this.repositoryCopier)).copy((OrganizationalUnit)Matchers.eq((Object)ou), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.eq((Object)module2Root));
        WorkspaceProject project = (WorkspaceProject)Mockito.spy((Object)new WorkspaceProject());
        ((WorkspaceProject)Mockito.doReturn((Object)"project").when((Object)project)).getName();
        ((WorkspaceProjectService)Mockito.doReturn((Object)project).when((Object)this.projectService)).resolveProject((Repository)repository1);
        WorkspaceProjectContextChangeEvent event = this.service.setupExamples(exOU, (List)exProjects);
        Assert.assertNull((Object)event.getOrganizationalUnit());
        Assert.assertEquals((Object)project, (Object)event.getWorkspaceProject());
        ((OrganizationalUnitService)Mockito.verify((Object)this.ouService, (VerificationMode)Mockito.never())).createOrganizationalUnit((String)Matchers.eq((Object)"ou"), (String)Matchers.eq((Object)""), (String)Matchers.eq((Object)""));
        ((RepositoryCopier)Mockito.verify((Object)this.repositoryCopier, (VerificationMode)Mockito.times((int)2))).copy((OrganizationalUnit)Matchers.eq((Object)ou), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class));
        ((Event)Mockito.verify(this.newProjectEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(NewProjectEvent.class));
    }

    @Test
    public void resolveRepositoryUrlOnWindows() {
        ((ExamplesServiceImpl)Mockito.doReturn((Object)"\\").when((Object)this.service)).getFileSeparator();
        String playgroundDirectoryPath = "C:\\folder\\.kie-wb-playground";
        String repositoryUrl = this.service.resolveRepositoryUrl("C:\\folder\\.kie-wb-playground");
        Assert.assertEquals((Object)"file:///C:/folder/.kie-wb-playground", (Object)repositoryUrl);
    }

    @Test
    public void resolveRepositoryUrlOnUnix() {
        ((ExamplesServiceImpl)Mockito.doReturn((Object)"/").when((Object)this.service)).getFileSeparator();
        String playgroundDirectoryPath = "/home/user/folder/.kie-wb-playground";
        String repositoryUrl = this.service.resolveRepositoryUrl("/home/user/folder/.kie-wb-playground");
        Assert.assertEquals((Object)"file:///home/user/folder/.kie-wb-playground", (Object)repositoryUrl);
    }

    @Test
    public void resolveGitRepositoryNotClonedBefore() {
        ExampleRepository playgroundRepository = new ExampleRepository("file:///home/user/folder/.kie-wb-playground");
        this.service.setPlaygroundRepository(playgroundRepository);
        ConfigGroup configGroup = new ConfigGroup();
        Mockito.when((Object)this.configurationFactory.newConfigGroup((ConfigType)Matchers.any(ConfigType.class), Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)configGroup);
        ((ConfigurationFactoryImpl)Mockito.doCallRealMethod().when((Object)this.configurationFactory)).newConfigItem(Matchers.anyString(), Matchers.anyBoolean());
        ((ConfigurationFactoryImpl)Mockito.doCallRealMethod().when((Object)this.configurationFactory)).newConfigItem(Matchers.anyString(), Matchers.anyString());
        ((ConfigurationFactoryImpl)Mockito.doCallRealMethod().when((Object)this.configurationFactory)).newConfigItem(Matchers.anyString(), Matchers.any(Object.class));
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.repositoryFactory.newRepository(configGroup)).thenReturn((Object)repository);
        Repository result = this.service.resolveGitRepository(playgroundRepository);
        Assert.assertEquals((Object)repository, (Object)result);
        Assert.assertEquals((Object)false, (Object)configGroup.getConfigItem("mirror").getValue());
        ((RepositoryFactory)Mockito.verify((Object)this.repositoryFactory, (VerificationMode)Mockito.times((int)1))).newRepository(configGroup);
    }

    @Test
    public void resolveGitRepositoryClonedBefore() {
        ExampleRepository playgroundRepository = new ExampleRepository("file:///home/user/folder/.kie-wb-playground");
        this.service.setPlaygroundRepository(playgroundRepository);
        GitRepository repository = (GitRepository)Mockito.mock(GitRepository.class);
        HashMap<String, String> repositoryEnvironment = new HashMap<String, String>();
        repositoryEnvironment.put("origin", playgroundRepository.getUrl());
        Mockito.when((Object)repository.getEnvironment()).thenReturn(repositoryEnvironment);
        this.service.getClonedRepositories().add(repository);
        Repository result = this.service.resolveGitRepository(playgroundRepository);
        Assert.assertEquals((Object)repository, (Object)result);
        ((RepositoryFactory)Mockito.verify((Object)this.repositoryFactory, (VerificationMode)Mockito.never())).newRepository((ConfigGroup)Matchers.any(ConfigGroup.class));
    }

    private GitRepository makeGitRepository() {
        GitRepository repository = new GitRepository("guvnorng-playground", new Space("space"));
        HashMap<String, Branch> branches = new HashMap<String, Branch>();
        branches.put("master", new Branch("master", (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class)));
        repository.setBranches(branches);
        return repository;
    }
}

