/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.backend.validation.CheckModulesValidator;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckModulesValidationTest {
    private CheckModulesValidator validator;
    @Mock
    private POMService pomService;
    @Mock
    private ExampleProject exampleProject;
    @Mock
    private POM pom;

    @Before
    public void setUp() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"/");
        Mockito.when((Object)this.exampleProject.getRoot()).thenReturn((Object)path);
        Mockito.when((Object)this.pomService.load((Path)Matchers.any())).thenReturn((Object)this.pom);
        this.validator = new CheckModulesValidator(this.pomService);
    }

    @Test
    public void testProjectHasNoModules() {
        Mockito.when((Object)this.pom.getModules()).thenReturn((Object)Collections.EMPTY_LIST);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertFalse((boolean)error.isPresent());
    }

    @Test
    public void testProjectHasModules() {
        Mockito.when((Object)this.pom.getModules()).thenReturn(Arrays.asList("aModule"));
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)CheckModulesValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }
}

