/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.validation;

import java.util.Arrays;
import java.util.Optional;
import org.apache.maven.model.Dependency;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.backend.validation.KieDependenciesValidator;
import org.kie.workbench.common.screens.examples.backend.validation.MandatoryDependencies;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class KieDependenciesValidationTest {
    private KieDependenciesValidator validator;
    @Mock
    private POMService pomService;
    @Mock
    private MandatoryDependencies mandatoryDependencies;
    @Mock
    private ExampleProject exampleProject;
    @Mock
    private Dependencies dependencies;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private POM pom;

    @Before
    public void setUp() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"/");
        Mockito.when((Object)this.exampleProject.getRoot()).thenReturn((Object)path);
        Mockito.when((Object)this.pomService.load((Path)Matchers.any())).thenReturn((Object)this.pom);
        Mockito.when((Object)this.mandatoryDependencies.getDependencies()).thenReturn(Arrays.asList(this.createMandatoryDependency("org.mandatory", "dependencyA", "1.0.0", "provided"), this.createMandatoryDependency("org.mandatory", "dependencyB", "2.1.0", "provided"), this.createMandatoryDependency("org.mandatory", "dependencyTest", "1.1.0", "test")));
        this.validator = new KieDependenciesValidator(this.pomService, this.mandatoryDependencies);
    }

    @Test
    public void testContainsAllMandatoryDependencies() {
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyA", "1.0.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyA", "1.0.0", "provided"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyB", "2.1.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyB", "2.1.0", "provided"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.not.mandatory", "dependencyA", "3.1.0")))).thenReturn((Object)this.createDependency("org.not.mandatory", "dependencyA", "3.1.0", "compile"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyTest", "1.1.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyTest", "1.1.0", "test"));
        Mockito.when((Object)this.pom.getDependencies()).thenReturn((Object)this.dependencies);
        Optional errors = this.validator.validate(this.exampleProject);
        Assert.assertFalse((boolean)errors.isPresent());
    }

    @Test
    public void testContainsMandatoryDependenciesWithWrongTestScope() {
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyA", "1.0.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyA", "1.0.0", "provided"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyB", "2.1.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyB", "2.1.0", "provided"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyTest", "1.1.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyTest", "1.1.0", "compile"));
        Mockito.when((Object)this.pom.getDependencies()).thenReturn((Object)this.dependencies);
        Optional errors = this.validator.validate(this.exampleProject);
        Assert.assertFalse((boolean)errors.isPresent());
    }

    @Test
    public void testMissingOneKieDependency() {
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyA", "1.0.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyA", "1.0.0", "provided"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.not.mandatory", "dependencyA", "3.1.0")))).thenReturn((Object)this.createDependency("org.not.mandatory", "dependencyA", "3.1.0", "compile"));
        Mockito.when((Object)this.pom.getDependencies()).thenReturn((Object)this.dependencies);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieDependenciesValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    @Test
    public void testMissingAllKieDependencies() {
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.not.mandatory", "dependencyA", "3.1.0")))).thenReturn((Object)this.createDependency("org.not.mandatory", "dependencyA", "3.1.0", "compile"));
        Mockito.when((Object)this.pom.getDependencies()).thenReturn((Object)this.dependencies);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieDependenciesValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    @Test
    public void testMissingAllKieDependenciesWithNullScope() {
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyA", "1.0.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyA", "1.0.0", "provided"));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyB", "2.1.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyB", "2.1.0", null));
        Mockito.when((Object)this.dependencies.get((GAV)Mockito.eq((Object)new GAV("org.mandatory", "dependencyTest", "1.1.0")))).thenReturn((Object)this.createDependency("org.mandatory", "dependencyTest", "1.1.0", "test"));
        Mockito.when((Object)this.pom.getDependencies()).thenReturn((Object)this.dependencies);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieDependenciesValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    private Dependency createMandatoryDependency(String groupId, String artifactId, String version, String scope) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setScope(scope);
        return dependency;
    }

    private org.guvnor.common.services.project.model.Dependency createDependency(String groupId, String artifactId, String version, String scope) {
        org.guvnor.common.services.project.model.Dependency dependency = new org.guvnor.common.services.project.model.Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setScope(scope);
        return dependency;
    }
}

