/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.validation;

import java.util.ArrayList;
import java.util.Optional;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Plugin;
import org.guvnor.common.services.project.service.POMService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.backend.validation.KieMavenPluginValidator;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class KieMavenPluginValidationTest {
    private KieMavenPluginValidator validator;
    @Mock
    private POMService pomService;
    @Mock
    private ExampleProject exampleProject;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private POM pom;

    @Before
    public void setUp() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"/");
        Mockito.when((Object)this.exampleProject.getRoot()).thenReturn((Object)path);
        Mockito.when((Object)this.pomService.load((Path)Matchers.any())).thenReturn((Object)this.pom);
        this.validator = new KieMavenPluginValidator(this.pomService);
        this.validator.kieGroupId = "org.kie";
        this.validator.kieArtifactId = "kie-maven-plugin";
        this.validator.kiePluginExample = "example";
    }

    @Test
    public void testContainsKieMavenPlugin() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(this.createPlugin(this.validator.kieGroupId, this.validator.kieArtifactId));
        Mockito.when((Object)this.pom.getBuild().getPlugins()).thenReturn(plugins);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertFalse((boolean)error.isPresent());
    }

    @Test
    public void testContainsNoPlugins() {
        ArrayList plugins = new ArrayList();
        Mockito.when((Object)this.pom.getBuild().getPlugins()).thenReturn(plugins);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieMavenPluginValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    @Test
    public void testDoesNotContainKieMavenPlugin() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(this.createPlugin("org.another.group", "another-maven-plugin"));
        Mockito.when((Object)this.pom.getBuild().getPlugins()).thenReturn(plugins);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieMavenPluginValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    @Test
    public void testDoesNotContainBuildSection() {
        Mockito.when((Object)this.pom.getBuild()).thenReturn(null);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieMavenPluginValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    @Test
    public void testContainsEmptyBuildSection() {
        ArrayList plugins = new ArrayList();
        Mockito.when((Object)this.pom.getBuild().getPlugins()).thenReturn(plugins);
        Optional error = this.validator.validate(this.exampleProject);
        Assert.assertTrue((boolean)error.isPresent());
        Assert.assertEquals((Object)KieMavenPluginValidator.class.getCanonicalName(), (Object)((ExampleProjectError)error.get()).getId());
    }

    private Plugin createPlugin(String groupId, String artifactId) {
        Plugin plugin = (Plugin)Mockito.mock(Plugin.class);
        Mockito.when((Object)plugin.getGroupId()).thenReturn((Object)groupId);
        Mockito.when((Object)plugin.getArtifactId()).thenReturn((Object)artifactId);
        return plugin;
    }
}

