/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExamplesMetaData;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.examples.validation.ExampleProjectValidator;
import org.kie.workbench.common.screens.examples.validation.ExampleProjectValidators;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;

@Service
@ApplicationScoped
public class ExamplesServiceImpl
implements ExamplesService {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesServiceImpl.class);
    private static final String PROJECT_DESCRIPTON = "project.description";
    private static final String KIE_WB_PLAYGROUND_ZIP = "org/kie/kie-wb-playground/kie-wb-playground.zip";
    private final Set<Repository> clonedRepositories = new HashSet<Repository>();
    private WorkspaceProjectService projectService;
    private IOService ioService;
    private ConfigurationFactory configurationFactory;
    private RepositoryFactory repositoryFactory;
    private KieModuleService moduleService;
    private RepositoryCopier repositoryCopier;
    private OrganizationalUnitService ouService;
    private Event<NewProjectEvent> newProjectEvent;
    private MetadataService metadataService;
    private ExampleRepository playgroundRepository;
    private ProjectScreenService projectScreenService;
    private ExampleProjectValidators validators;

    public ExamplesServiceImpl() {
    }

    @Inject
    public ExamplesServiceImpl(@Named(value="ioStrategy") IOService ioService, ConfigurationFactory configurationFactory, RepositoryFactory repositoryFactory, KieModuleService moduleService, RepositoryCopier repositoryCopier, OrganizationalUnitService ouService, WorkspaceProjectService projectService, MetadataService metadataService, Event<NewProjectEvent> newProjectEvent, ProjectScreenService projectScreenService, ExampleProjectValidators validators) {
        this.ioService = ioService;
        this.configurationFactory = configurationFactory;
        this.repositoryFactory = repositoryFactory;
        this.moduleService = moduleService;
        this.repositoryCopier = repositoryCopier;
        this.ouService = ouService;
        this.projectService = projectService;
        this.metadataService = metadataService;
        this.newProjectEvent = newProjectEvent;
        this.projectScreenService = projectScreenService;
        this.validators = validators;
    }

    @PostConstruct
    public void initPlaygroundRepository() {
        try {
            String userDir = System.getProperty("user.dir");
            File playgroundDirectory = new File(userDir, ".kie-wb-playground");
            if (playgroundDirectory.exists()) {
                this.cleanPlaygroundDirectory(playgroundDirectory.toPath());
            }
            playgroundDirectory.mkdirs();
            URL resource = this.getClass().getClassLoader().getResource(KIE_WB_PLAYGROUND_ZIP);
            if (resource == null) {
                logger.warn("Playground repository jar not found on classpath.");
                return;
            }
            try (ZipInputStream inputStream = new ZipInputStream(resource.openStream());){
                ZipEntry zipEntry = null;
                while ((zipEntry = inputStream.getNextEntry()) != null) {
                    byte[] buffer = new byte[1024];
                    File file = new File(playgroundDirectory, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        int read = -1;
                        while ((read = inputStream.read(buffer)) != -1) {
                            fos.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                Git git = Git.init().setBare(false).setDirectory(playgroundDirectory).call();
                git.add().addFilepattern(".").call();
                git.commit().setMessage("Initial commit").call();
                String repositoryUrl = this.resolveRepositoryUrl(playgroundDirectory.getAbsolutePath());
                this.playgroundRepository = new ExampleRepository(repositoryUrl);
            }
        }
        catch (java.io.IOException | GitAPIException e) {
            logger.error("Unable to initialize playground git repository. Only custom repository definition will be available in the Workbench.", e);
        }
    }

    private void cleanPlaygroundDirectory(Path playgroundDirectoryPath) throws java.io.IOException {
        Files.walkFileTree(playgroundDirectoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws java.io.IOException {
                file.toFile().delete();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, java.io.IOException exc) throws java.io.IOException {
                dir.toFile().delete();
                return FileVisitResult.CONTINUE;
            }
        });
    }

    String resolveRepositoryUrl(String playgroundDirectoryPath) {
        if ("\\".equals(this.getFileSeparator())) {
            return "file:///" + playgroundDirectoryPath.replaceAll("\\\\", "/");
        }
        return "file://" + playgroundDirectoryPath;
    }

    public ExamplesMetaData getMetaData() {
        return new ExamplesMetaData(this.getPlaygroundRepository());
    }

    public ExampleRepository getPlaygroundRepository() {
        return this.playgroundRepository;
    }

    public Set<ExampleProject> getProjects(ExampleRepository repository) {
        if (repository == null) {
            return Collections.emptySet();
        }
        String repositoryURL = repository.getUrl();
        if (repositoryURL == null || repositoryURL.trim().isEmpty()) {
            return Collections.emptySet();
        }
        Repository gitRepository = this.resolveGitRepository(repository);
        if (gitRepository == null) {
            return Collections.emptySet();
        }
        Set modules = this.moduleService.getAllModules((Branch)gitRepository.getBranch("master").get());
        Set<ExampleProject> exampleProjects = this.convert(modules);
        return this.validateProjects(exampleProjects);
    }

    private Set<ExampleProject> validateProjects(Set<ExampleProject> exampleProjects) {
        return exampleProjects.stream().map(exampleProject -> {
            List errors = this.getValidators().stream().map(exampleProjectValidation -> exampleProjectValidation.validate(exampleProject)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return new ExampleProject(exampleProject.getRoot(), exampleProject.getName(), exampleProject.getDescription(), exampleProject.getTags(), errors);
        }).collect(Collectors.toSet());
    }

    protected List<ExampleProjectValidator> getValidators() {
        return this.validators.getValidators();
    }

    Repository resolveGitRepository(ExampleRepository exampleRepository) {
        if (exampleRepository.equals((Object)this.playgroundRepository)) {
            return this.clonedRepositories.stream().filter(r -> exampleRepository.getUrl().equals(r.getEnvironment().get("origin"))).findFirst().orElseGet(() -> this.cloneRepository(exampleRepository.getUrl()));
        }
        return this.cloneRepository(exampleRepository.getUrl(), exampleRepository.getUserName(), exampleRepository.getPassword());
    }

    private Repository cloneRepository(String repositoryURL) {
        return this.cloneRepository(repositoryURL, null, null);
    }

    private Repository cloneRepository(final String repositoryURL, final String userName, final String password) {
        Repository repository = null;
        try {
            String alias = this.getExampleAlias(repositoryURL);
            HashMap<String, Object> env = new HashMap<String, Object>(){
                {
                    this.put("origin", repositoryURL);
                    this.put("scheme", GitRepository.SCHEME.toString());
                    this.put("replaceIfExists", true);
                    this.put("username", userName);
                    this.put("password", password);
                    this.put("mirror", false);
                }
            };
            ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "system", alias, "");
            for (Map.Entry entry : env.entrySet()) {
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem((String)entry.getKey(), entry.getValue()));
            }
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("avoid_index", "true"));
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("space", "system"));
            repository = this.repositoryFactory.newRepository(repositoryConfig);
            this.clonedRepositories.add(repository);
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    String getExampleAlias(String repositoryURL) {
        String alias = repositoryURL;
        int lastDotIndex = (alias = alias.substring(alias.lastIndexOf("/") + 1)).lastIndexOf(46);
        if (lastDotIndex > 0) {
            alias = alias.substring(0, lastDotIndex);
        }
        return "examples-" + alias;
    }

    String getFileSeparator() {
        return FileSystems.getDefault().getSeparator();
    }

    private Set<ExampleProject> convert(Set<Module> modules) {
        return modules.stream().map(p -> this.makeExampleProject((Module)p)).collect(Collectors.toSet());
    }

    private ExampleProject makeExampleProject(Module module) {
        String description = this.readDescription(module);
        List<String> tags = this.getTags(module);
        return new ExampleProject(module.getRootPath(), module.getModuleName(), description, tags);
    }

    private String readDescription(Module module) {
        org.uberfire.backend.vfs.Path root = module.getRootPath();
        POM pom = module.getPom();
        org.uberfire.java.nio.file.Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)root);
        org.uberfire.java.nio.file.Path nioDescription = nioRoot.resolve(PROJECT_DESCRIPTON);
        String description = "Example '" + module.getModuleName() + "' module";
        if (this.ioService.exists(nioDescription)) {
            description = this.ioService.readAllString(nioDescription);
        } else if (pom != null && pom.getDescription() != null && !pom.getDescription().isEmpty()) {
            description = pom.getDescription();
        }
        if (description != null) {
            return description.replaceAll("[\\s]+", " ");
        }
        return description;
    }

    private List<String> getTags(Module module) {
        List tags = this.metadataService.getTags(module.getPomXMLPath());
        tags.sort(String::compareTo);
        return tags;
    }

    public WorkspaceProjectContextChangeEvent setupExamples(ExampleOrganizationalUnit exampleTargetOU, List<ExampleProject> exampleProjects) {
        PortablePreconditions.checkNotNull((String)"exampleTargetOU", (Object)exampleTargetOU);
        PortablePreconditions.checkNotNull((String)"exampleProjects", exampleProjects);
        PortablePreconditions.checkCondition((String)"Must have at least one ExampleProject", (exampleProjects.size() > 0 ? 1 : 0) != 0);
        String targetOUName = exampleTargetOU.getName();
        OrganizationalUnit targetOU = this.getOrganizationalUnit(targetOUName);
        WorkspaceProject firstExampleProject = null;
        for (ExampleProject exampleProject : exampleProjects) {
            try {
                Repository targetRepository = this.repositoryCopier.copy(targetOU, exampleProject.getName(), exampleProject.getRoot());
                WorkspaceProject project = this.projectService.resolveProject(targetRepository);
                project = this.renameIfNecessary(targetOU, project);
                this.newProjectEvent.fire((Object)new NewProjectEvent(project));
                if (firstExampleProject != null) continue;
                firstExampleProject = project;
            }
            catch (IOException ioe) {
                logger.error("Unable to create Example(s).", (Throwable)ioe);
            }
        }
        return new WorkspaceProjectContextChangeEvent(firstExampleProject, firstExampleProject.getMainModule());
    }

    private WorkspaceProject renameIfNecessary(OrganizationalUnit ou, WorkspaceProject project) {
        String name = project.getName();
        Collection projectsWithSameName = this.projectService.getAllWorkspaceProjectsByName(ou, name);
        if (projectsWithSameName.size() > 1) {
            name = this.projectService.createFreshProjectName(ou, project.getName());
        }
        if (!name.equals(project.getName())) {
            org.uberfire.backend.vfs.Path pomXMLPath = project.getMainModule().getPomXMLPath();
            ProjectScreenModel model = this.projectScreenService.load(pomXMLPath);
            model.getPOM().setName(name);
            this.projectScreenService.save(pomXMLPath, model, "");
            return this.projectService.resolveProject(pomXMLPath);
        }
        return project;
    }

    private OrganizationalUnit getOrganizationalUnit(String targetOUName) {
        OrganizationalUnit targetOU = this.ouService.getOrganizationalUnit(targetOUName);
        if (targetOU == null) {
            targetOU = this.createOrganizationalUnit(targetOUName);
        }
        return targetOU;
    }

    private OrganizationalUnit createOrganizationalUnit(String name) {
        OrganizationalUnit ou = this.ouService.createOrganizationalUnit(name, "", "");
        return ou;
    }

    public int priority() {
        return 0;
    }

    public void dispose() {
        for (Repository repository : this.clonedRepositories) {
            try {
                if (!repository.getDefaultBranch().isPresent()) continue;
                this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)((Branch)repository.getDefaultBranch().get()).getPath()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to remove transient Repository '" + repository.getAlias() + "'.", (Throwable)e);
            }
        }
    }

    Set<Repository> getClonedRepositories() {
        return this.clonedRepositories;
    }

    void setPlaygroundRepository(ExampleRepository playgroundRepository) {
        this.playgroundRepository = playgroundRepository;
    }
}

