/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.validation;

import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.maven.model.Dependency;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.kie.workbench.common.screens.examples.backend.validation.MandatoryDependencies;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.kie.workbench.common.screens.examples.validation.ExampleProjectValidator;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class KieDependenciesValidator
extends ExampleProjectValidator {
    public static final String TEST_SCOPE = "test";
    private MandatoryDependencies mandatoryDependencies;
    private POMService pomService;

    public KieDependenciesValidator() {
    }

    @Inject
    public KieDependenciesValidator(POMService pomService, MandatoryDependencies mandatoryDependencies) {
        this.pomService = pomService;
        this.mandatoryDependencies = mandatoryDependencies;
    }

    protected Optional<ExampleProjectError> getError(Path projectPath) {
        POM pom = this.getPom(this.pomService, projectPath);
        Dependencies dependencies = pom.getDependencies();
        List missingDependencies = this.mandatoryDependencies.getDependencies().stream().filter(mandatoryDependency -> {
            Optional<org.guvnor.common.services.project.model.Dependency> dependency = Optional.ofNullable(dependencies.get(new GAV(this.buildGAV((Dependency)mandatoryDependency))));
            return dependency.map(d -> this.isScopeInvalid((Dependency)mandatoryDependency, (org.guvnor.common.services.project.model.Dependency)d)).orElse(true);
        }).collect(Collectors.toList());
        if (missingDependencies.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ExampleProjectError(KieDependenciesValidator.class.getCanonicalName(), missingDependencies.stream().map(dependency -> this.buildGAV((Dependency)dependency)).collect(Collectors.joining(", "))));
    }

    private boolean isScopeInvalid(Dependency mandatoryDependency, org.guvnor.common.services.project.model.Dependency dependency) {
        if (TEST_SCOPE.equalsIgnoreCase(mandatoryDependency.getScope())) {
            return false;
        }
        return !mandatoryDependency.getScope().equalsIgnoreCase(dependency.getScope());
    }

    protected String buildGAV(Dependency dependency) {
        return MessageFormat.format("{0}:{1}:{2}:{3}", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope());
    }
}

