/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.repository;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.client.wizard.pages.repository.RepositoryPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.repository.RepositoryPageView;
import org.kie.workbench.common.screens.examples.client.wizard.widgets.ComboBox;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;

@Dependent
@Templated
public class RepositoryPageViewImpl
extends Composite
implements RepositoryPageView {
    @DataField(value="repository-form")
    Element repositoryGroup = DOM.createDiv();
    @DataField
    ComboBox repositoryDropdown = (ComboBox)((Object)GWT.create(ComboBox.class));
    @DataField(value="repository-help")
    Element repositoryHelp = DOM.createSpan();
    private RepositoryPage presenter;

    @PostConstruct
    public void setup() {
        this.repositoryDropdown.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                RepositoryPageViewImpl.this.presenter.setSelectedRepository(new ExampleRepository((String)event.getValue()));
            }
        });
    }

    public void init(RepositoryPage presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initialise() {
        this.repositoryDropdown.setText("");
    }

    @Override
    public void setPlaceHolder(String placeHolder) {
        this.repositoryDropdown.setPlaceholder(placeHolder);
    }

    @Override
    public void setRepositories(List<ExampleRepository> repositories) {
        this.repositoryDropdown.clear();
        for (ExampleRepository repository : repositories) {
            this.repositoryDropdown.addItem(repository.getUrl());
        }
    }

    @Override
    public void setRepository(ExampleRepository repository) {
        this.repositoryDropdown.setText(repository.getUrl());
    }

    @Override
    public void setUrlGroupType(ValidationState state) {
        StyleHelper.addUniqueEnumStyleName((Element)this.repositoryGroup, ValidationState.class, (Style.HasCssName)state);
    }

    @Override
    public void showUrlHelpMessage(String message) {
        this.repositoryHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.repositoryHelp.setInnerText(message);
    }

    @Override
    public void hideUrlHelpMessage() {
        this.repositoryHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.repositoryHelp.setInnerText("");
    }
}

