/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.project;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.pages.BaseExamplesWizardPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.FetchRepositoryView;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.NoRepositoryURLView;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectPageView;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageSelectedEvent;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ProjectPage
extends BaseExamplesWizardPage
implements ProjectPageView.Presenter {
    private IsWidget activeView;
    private ProjectPageView projectsView;
    private NoRepositoryURLView noRepositoryURLView;
    private FetchRepositoryView fetchingRepositoryView;
    private Event<WizardPageSelectedEvent> pageSelectedEvent;

    public ProjectPage() {
    }

    @Inject
    public ProjectPage(ProjectPageView projectsView, NoRepositoryURLView noRepositoryURLView, FetchRepositoryView fetchingRepositoryView, Event<WizardPageSelectedEvent> pageSelectedEvent, Event<WizardPageStatusChangeEvent> pageStatusChangedEvent, TranslationService translator, Caller<ExamplesService> examplesService) {
        super(translator, examplesService, pageStatusChangedEvent);
        this.projectsView = projectsView;
        this.noRepositoryURLView = noRepositoryURLView;
        this.fetchingRepositoryView = fetchingRepositoryView;
        this.pageSelectedEvent = pageSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.projectsView.init(this);
    }

    public void initialise() {
        this.projectsView.initialise();
        this.activeView = this.noRepositoryURLView;
    }

    @Override
    public void destroy() {
        this.projectsView.destroy();
    }

    public String getTitle() {
        return this.translator.format("ProjectPage.WizardSelectProjectPageTitle", new Object[0]);
    }

    public void prepareView() {
        ExampleRepository sourceRepository = this.model.getSourceRepository();
        ExampleRepository selectedRepository = this.model.getSelectedRepository();
        if (!this.isRepositorySelected(selectedRepository)) {
            this.activeView = this.noRepositoryURLView;
        } else if (!selectedRepository.isUrlValid()) {
            this.activeView = this.noRepositoryURLView;
        } else if (!selectedRepository.equals((Object)sourceRepository)) {
            this.activeView = this.fetchingRepositoryView;
            this.fetchRepository(selectedRepository);
        } else {
            this.activeView = this.projectsView;
        }
    }

    private boolean isRepositorySelected(ExampleRepository repository) {
        if (repository == null) {
            return false;
        }
        return repository.getUrl() != null && !repository.getUrl().isEmpty();
    }

    private void fetchRepository(final ExampleRepository selectedRepository) {
        ((ExamplesService)this.examplesService.call((RemoteCallback)new RemoteCallback<Set<ExampleProject>>(){

            public void callback(Set<ExampleProject> projects) {
                ProjectPage.this.activeView = (IsWidget)ProjectPage.this.projectsView;
                ProjectPage.this.model.getProjects().clear();
                ProjectPage.this.model.setSourceRepository(selectedRepository);
                List sortedProjects = ProjectPage.this.sort(projects);
                ProjectPage.this.projectsView.setProjectsInRepository(sortedProjects);
                ProjectPage.this.pageSelectedEvent.fire((Object)new WizardPageSelectedEvent((WizardPage)ProjectPage.this));
            }
        }, (ErrorCallback)new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                ProjectPage.this.model.setSourceRepository(null);
                ProjectPage.this.model.getSelectedRepository().setUrlValid(false);
                return super.error(message, throwable);
            }
        })).getProjects(selectedRepository);
    }

    private List<ExampleProject> sort(Set<ExampleProject> projects) {
        ArrayList<ExampleProject> sortedProjects = new ArrayList<ExampleProject>(projects);
        Collections.sort(sortedProjects, new Comparator<ExampleProject>(){

            @Override
            public int compare(ExampleProject o1, ExampleProject o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedProjects;
    }

    public Widget asWidget() {
        return this.activeView.asWidget();
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)(this.model.getProjects().size() > 0 ? 1 : 0));
    }

    @Override
    public void addProject(ExampleProject project) {
        this.model.addProject(project);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    @Override
    public void removeProject(ExampleProject project) {
        this.model.removeProject(project);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }
}

