/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.project;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectItemView;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectPageView;
import org.kie.workbench.common.screens.examples.model.ExampleProject;

@Dependent
@Templated
public class ProjectPageViewImpl
extends Composite
implements ProjectPageView {
    @DataField
    Element projects = DOM.createDiv();
    @DataField(value="project-description")
    Element projectDescription = DOM.createDiv();
    private ProjectPage presenter;
    private Set<ProjectItemView> projectItemViews = new HashSet<ProjectItemView>();

    public void init(ProjectPage presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initialise() {
        this.destroy();
    }

    @Override
    public void setProjectsInRepository(List<ExampleProject> projects) {
        this.destroy();
        for (ExampleProject project : projects) {
            ProjectItemView w = this.makeProjectWidget(project);
            this.projects.appendChild((Node)w.asWidget().getElement());
            this.projectItemViews.add(w);
        }
    }

    @Override
    public void destroy() {
        for (ProjectItemView piw : this.projectItemViews) {
            IOC.getBeanManager().destroyBean((Object)piw);
        }
        this.projectItemViews.clear();
        this.projects.removeAllChildren();
    }

    private ProjectItemView makeProjectWidget(final ExampleProject project) {
        ProjectItemView projectItemView = (ProjectItemView)IOC.getBeanManager().lookupBean(ProjectItemView.class, new Annotation[0]).getInstance();
        projectItemView.setProject(project);
        projectItemView.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                boolean selected = (Boolean)event.getValue();
                if (selected) {
                    ProjectPageViewImpl.this.presenter.addProject(project);
                } else {
                    ProjectPageViewImpl.this.presenter.removeProject(project);
                }
            }
        });
        projectItemView.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SafeHtmlBuilder shb = new SafeHtmlBuilder();
                shb.appendEscaped(project.getDescription());
                ProjectPageViewImpl.this.projectDescription.setInnerSafeHtml(shb.toSafeHtml());
            }
        });
        return projectItemView;
    }
}

