/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.repository;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.pages.BaseExamplesWizardPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.repository.RepositoryPageView;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.util.URIUtil;

@Dependent
public class RepositoryPage
extends BaseExamplesWizardPage
implements RepositoryPageView.Presenter {
    private RepositoryPageView view;

    public RepositoryPage() {
    }

    @Inject
    public RepositoryPage(RepositoryPageView view, TranslationService translator, Caller<ExamplesService> examplesService, Event<WizardPageStatusChangeEvent> pageStatusChangedEvent) {
        super(translator, examplesService, pageStatusChangedEvent);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setPlaceHolder(this.translator.format("RepositoryPage.WizardRepositoriesPlaceHolder", new Object[0]));
    }

    public void initialise() {
        this.view.initialise();
    }

    public String getTitle() {
        return this.translator.format("RepositoryPage.WizardSelectRepositoryPageTitle", new Object[0]);
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void isComplete(Callback<Boolean> callback) {
        ExampleRepository selectedRepository = this.model.getSelectedRepository();
        callback.callback((Object)this.validateUrl(selectedRepository));
    }

    @Override
    public void setRepositories(Set<ExampleRepository> repositories) {
        if (repositories == null) {
            this.view.setRepositories(Collections.emptyList());
            return;
        }
        List<ExampleRepository> sortedRepositories = this.sort(repositories);
        this.view.setRepositories(sortedRepositories);
        if (sortedRepositories.size() > 0) {
            this.model.setSelectedRepository(sortedRepositories.get(0));
            this.view.setRepository(sortedRepositories.get(0));
        }
    }

    private List<ExampleRepository> sort(Set<ExampleRepository> repositories) {
        ArrayList<ExampleRepository> sortedRepositories = new ArrayList<ExampleRepository>(repositories);
        Collections.sort(sortedRepositories, new Comparator<ExampleRepository>(){

            @Override
            public int compare(ExampleRepository o1, ExampleRepository o2) {
                return o1.getUrl().compareTo(o2.getUrl());
            }
        });
        return sortedRepositories;
    }

    @Override
    public void setSelectedRepository(ExampleRepository selectedRepository) {
        this.model.setSelectedRepository(selectedRepository);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    private boolean validateUrl(ExampleRepository selectedRepository) {
        if (selectedRepository == null) {
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMessage(this.translator.format("RepositoryPage.WizardSelectRepositoryURLMandatory", new Object[0]));
            return false;
        }
        String url = selectedRepository.getUrl();
        if (url == null || url.trim().isEmpty()) {
            selectedRepository.setUrlValid(false);
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMessage(this.translator.format("RepositoryPage.WizardSelectRepositoryURLMandatory", new Object[0]));
            return false;
        }
        if (!this.isUrlValid(url)) {
            selectedRepository.setUrlValid(false);
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMessage(this.translator.format("RepositoryPage.WizardSelectRepositoryURLFormatInvalid", new Object[0]));
            return false;
        }
        selectedRepository.setUrlValid(true);
        this.view.setUrlGroupType(ValidationState.NONE);
        this.view.hideUrlHelpMessage();
        return true;
    }

    boolean isUrlValid(String url) {
        return URIUtil.isValid((String)url);
    }
}

