/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.organizationalunit;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.pages.BaseExamplesWizardPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.organizationalunit.OUPageView;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleTargetRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class OUPage
extends BaseExamplesWizardPage
implements OUPageView.Presenter {
    private OUPageView view;

    public OUPage() {
    }

    @Inject
    public OUPage(OUPageView view, TranslationService translator, Caller<ExamplesService> examplesService, Event<WizardPageStatusChangeEvent> pageStatusChangedEvent) {
        super(translator, examplesService, pageStatusChangedEvent);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setTargetRepositoryPlaceHolder(this.translator.format("OrganizationalUnitPage.WizardTargetRepositoryPlaceHolder", new Object[0]));
        this.view.setOrganizationalUnitsPlaceHolder(this.translator.format("OrganizationalUnitPage.WizardOrganizationalUnitsPlaceHolder", new Object[0]));
    }

    public void initialise() {
        this.view.initialise();
    }

    public String getTitle() {
        return this.translator.format("OrganizationalUnitPage.WizardSelectOrganizationalUnitPageTitle", new Object[0]);
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void isComplete(final Callback<Boolean> callback) {
        ExampleTargetRepository targetRepository = this.model.getTargetRepository();
        ExampleOrganizationalUnit targetOrganizationalUnit = this.model.getTargetOrganizationalUnit();
        this.validateOrganizationalUnit(targetRepository, targetOrganizationalUnit, new Callback<Boolean>(){

            public void callback(Boolean result) {
                callback.callback((Object)result);
            }
        });
    }

    @Override
    public void setOrganizationalUnits(Set<ExampleOrganizationalUnit> organizationalUnits) {
        if (organizationalUnits == null) {
            this.view.setOrganizationalUnits(Collections.emptyList());
            return;
        }
        List<ExampleOrganizationalUnit> sortedOrganizationalUnits = this.sort(organizationalUnits);
        this.view.setOrganizationalUnits(sortedOrganizationalUnits);
        if (sortedOrganizationalUnits.size() > 0) {
            if (this.model.getTargetOrganizationalUnit() != null) {
                this.view.setOrganizationalUnit(this.model.getTargetOrganizationalUnit());
            } else {
                this.model.setTargetOrganizationalUnit(sortedOrganizationalUnits.get(0));
                this.view.setOrganizationalUnit(sortedOrganizationalUnits.get(0));
            }
        }
    }

    private List<ExampleOrganizationalUnit> sort(Set<ExampleOrganizationalUnit> repositories) {
        ArrayList<ExampleOrganizationalUnit> sortedRepositories = new ArrayList<ExampleOrganizationalUnit>(repositories);
        Collections.sort(sortedRepositories, new Comparator<ExampleOrganizationalUnit>(){

            @Override
            public int compare(ExampleOrganizationalUnit o1, ExampleOrganizationalUnit o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedRepositories;
    }

    @Override
    public void setTargetRepository(ExampleTargetRepository repository) {
        this.model.setTargetRepository(repository);
        this.view.setTargetRepository(repository);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    @Override
    public void setTargetOrganizationalUnit(ExampleOrganizationalUnit organizationalUnit) {
        this.model.setTargetOrganizationalUnit(organizationalUnit);
        this.view.setOrganizationalUnit(organizationalUnit);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    private void validateOrganizationalUnit(ExampleTargetRepository targetRepository, ExampleOrganizationalUnit targetOrganizationalUnit, final Callback<Boolean> callback) {
        boolean isValid = true;
        if (targetOrganizationalUnit == null) {
            this.view.setTargetOrganizationalUnitGroupType(ValidationState.ERROR);
            this.view.showTargetOrganizationalUnitHelpMessage(this.translator.format("OrganizationalUnitPage.WizardSelectOrganizationalUnitMandatory", new Object[0]));
            isValid = false;
        } else {
            String targetOrganizationalUnitName = targetOrganizationalUnit.getName();
            if (targetOrganizationalUnitName == null || targetOrganizationalUnitName.trim().isEmpty()) {
                this.view.setTargetOrganizationalUnitGroupType(ValidationState.ERROR);
                this.view.showTargetOrganizationalUnitHelpMessage(this.translator.format("OrganizationalUnitPage.WizardSelectOrganizationalUnitMandatory", new Object[0]));
                isValid = false;
            } else {
                this.view.setTargetOrganizationalUnitGroupType(ValidationState.NONE);
                this.view.hideTargetOrganizationalUnitHelpMessage();
            }
        }
        if (targetRepository == null) {
            this.view.setTargetRepositoryGroupType(ValidationState.ERROR);
            this.view.showTargetRepositoryHelpMessage(this.translator.format("OrganizationalUnitPage.WizardSelectTargetRepositoryMandatory", new Object[0]));
            callback.callback((Object)false);
        } else {
            String targetRepositoryName = targetRepository.getAlias();
            if (targetRepositoryName == null || targetRepositoryName.trim().isEmpty()) {
                this.view.setTargetRepositoryGroupType(ValidationState.ERROR);
                this.view.showTargetRepositoryHelpMessage(this.translator.format("OrganizationalUnitPage.WizardSelectTargetRepositoryMandatory", new Object[0]));
                callback.callback((Object)false);
            } else {
                final boolean _isValid = isValid;
                ((ExamplesService)this.examplesService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                    public void callback(Boolean valid) {
                        if (Boolean.TRUE.equals(valid)) {
                            OUPage.this.view.setTargetRepositoryGroupType(ValidationState.NONE);
                            OUPage.this.view.hideTargetRepositoryHelpMessage();
                        } else {
                            OUPage.this.view.setTargetRepositoryGroupType(ValidationState.ERROR);
                            OUPage.this.view.showTargetRepositoryHelpMessage(OUPage.this.translator.format("OrganizationalUnitPage.WizardSelectTargetRepositoryInvalid", new Object[0]));
                        }
                        callback.callback((Object)(valid != false && _isValid ? 1 : 0));
                    }
                })).validateRepositoryName(targetRepositoryName);
            }
        }
    }
}

