/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.repository;

import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.pages.BaseExamplesWizardPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.repository.RepositoryPageView;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.util.URIUtil;

@Dependent
public class RepositoryPage
extends BaseExamplesWizardPage
implements RepositoryPageView.Presenter {
    private RepositoryPageView view;
    private ExampleRepository stockRepository;

    public RepositoryPage() {
    }

    @Inject
    public RepositoryPage(RepositoryPageView view, TranslationService translator, Caller<ExamplesService> examplesService, Event<WizardPageStatusChangeEvent> pageStatusChangedEvent) {
        super(translator, examplesService, pageStatusChangedEvent);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setPlaceHolder(this.translator.format("RepositoryPage.WizardRepositoriesPlaceHolder", new Object[0]));
    }

    public void initialise() {
        this.view.initialise();
    }

    public String getTitle() {
        return this.translator.format("RepositoryPage.WizardSelectRepositoryPageTitle", new Object[0]);
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void isComplete(Callback<Boolean> callback) {
        ExampleRepository selectedRepository = this.model.getSelectedRepository();
        callback.callback((Object)this.validateUrl(selectedRepository));
    }

    @Override
    public void setPlaygroundRepository(ExampleRepository stockRepository) {
        this.stockRepository = stockRepository;
        if (stockRepository == null) {
            this.view.showRepositoryUrlInputForm();
            this.view.setCustomRepositoryOption();
            this.view.disableStockRepositoryOption();
            this.model.setSelectedRepository(null);
        } else {
            this.view.hideRepositoryUrlInputForm();
            this.view.setStockRepositoryOption();
            this.model.setSelectedRepository(stockRepository);
        }
    }

    @Override
    public void playgroundRepositorySelected() {
        this.model.setSelectedRepository(this.stockRepository);
        this.view.hideRepositoryUrlInputForm();
        this.view.setCustomRepositoryValue(null);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    @Override
    public void onCustomRepositorySelected() {
        this.view.showRepositoryUrlInputForm();
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    @Override
    public void onCustomRepositoryValueChanged() {
        this.model.setSelectedRepository(new ExampleRepository(this.view.getCustomRepositoryValue()));
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    private boolean validateUrl(ExampleRepository selectedRepository) {
        if (selectedRepository == null) {
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMessage(this.translator.format("RepositoryPage.WizardSelectRepositoryURLMandatory", new Object[0]));
            return false;
        }
        String url = selectedRepository.getUrl();
        if (url == null || url.trim().isEmpty()) {
            selectedRepository.setUrlValid(false);
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMessage(this.translator.format("RepositoryPage.WizardSelectRepositoryURLMandatory", new Object[0]));
            return false;
        }
        if (!this.isUrlValid(url)) {
            selectedRepository.setUrlValid(false);
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMessage(this.translator.format("RepositoryPage.WizardSelectRepositoryURLFormatInvalid", new Object[0]));
            return false;
        }
        selectedRepository.setUrlValid(true);
        this.view.setUrlGroupType(ValidationState.NONE);
        this.view.hideUrlHelpMessage();
        return true;
    }

    boolean isUrlValid(String url) {
        return URIUtil.isValid((String)url);
    }
}

