/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.organizationalunit;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.client.wizard.pages.organizationalunit.OUPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.organizationalunit.OUPageView;
import org.kie.workbench.common.screens.examples.client.wizard.widgets.ComboBox;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleTargetRepository;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;

@Dependent
@Templated
public class OUPageViewImpl
extends Composite
implements OUPageView {
    @DataField(value="target-repository-form")
    Element targetRepositoryGroup = DOM.createDiv();
    @DataField(value="targetRepositoryTextBox")
    TextBox targetRepositoryTextBox = (TextBox)GWT.create(TextBox.class);
    @DataField(value="target-repository-help")
    Element targetRepositoryHelp = DOM.createSpan();
    @DataField(value="organizational-units-form")
    Element organizationalUnitsGroup = DOM.createDiv();
    @DataField
    ComboBox organizationalUnitsDropdown = (ComboBox)((Object)GWT.create(ComboBox.class));
    @DataField(value="organizational-units-help")
    Element organizationalUnitsHelp = DOM.createSpan();
    private OUPage presenter;

    @PostConstruct
    public void setup() {
        this.targetRepositoryTextBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                OUPageViewImpl.this.presenter.setTargetRepository(new ExampleTargetRepository((String)event.getValue()));
            }
        });
        this.organizationalUnitsDropdown.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                OUPageViewImpl.this.presenter.setTargetOrganizationalUnit(new ExampleOrganizationalUnit((String)event.getValue()));
            }
        });
    }

    public void init(OUPage presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initialise() {
        this.targetRepositoryTextBox.setText("");
        this.organizationalUnitsDropdown.setText("");
    }

    @Override
    public void setTargetRepositoryPlaceHolder(String placeHolder) {
        this.targetRepositoryTextBox.setPlaceholder(placeHolder);
    }

    @Override
    public void setOrganizationalUnitsPlaceHolder(String placeHolder) {
        this.organizationalUnitsDropdown.setPlaceholder(placeHolder);
    }

    @Override
    public void setOrganizationalUnits(List<ExampleOrganizationalUnit> organizationalUnits) {
        this.organizationalUnitsDropdown.clear();
        for (ExampleOrganizationalUnit organizationalUnit : organizationalUnits) {
            this.organizationalUnitsDropdown.addItem(organizationalUnit.getName());
        }
    }

    @Override
    public void setOrganizationalUnit(ExampleOrganizationalUnit organizationalUnit) {
        this.organizationalUnitsDropdown.setText(organizationalUnit.getName());
    }

    @Override
    public void setTargetRepository(ExampleTargetRepository repository) {
        this.targetRepositoryTextBox.setText(repository.getAlias());
    }

    @Override
    public void setTargetRepositoryGroupType(ValidationState state) {
        StyleHelper.addUniqueEnumStyleName((Element)this.targetRepositoryGroup, ValidationState.class, (Style.HasCssName)state);
    }

    @Override
    public void showTargetRepositoryHelpMessage(String message) {
        this.targetRepositoryHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.targetRepositoryHelp.setInnerText(message);
    }

    @Override
    public void hideTargetRepositoryHelpMessage() {
        this.targetRepositoryHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.targetRepositoryHelp.setInnerText("");
    }

    @Override
    public void setTargetOrganizationalUnitGroupType(ValidationState state) {
        StyleHelper.addUniqueEnumStyleName((Element)this.organizationalUnitsGroup, ValidationState.class, (Style.HasCssName)state);
    }

    @Override
    public void showTargetOrganizationalUnitHelpMessage(String message) {
        this.organizationalUnitsHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.organizationalUnitsHelp.setInnerText(message);
    }

    @Override
    public void hideTargetOrganizationalUnitHelpMessage() {
        this.organizationalUnitsHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.organizationalUnitsHelp.setInnerText("");
    }
}

