/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.project;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectItemView;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.TagItemView;
import org.kie.workbench.common.screens.examples.model.ExampleProject;

@Dependent
@Templated
public class ProjectItemViewImpl
extends Composite
implements ProjectItemView {
    @DataField(value="project")
    Element project = DOM.createDiv();
    @DataField(value="project-selected")
    InputElement projectSelected = (InputElement)DOM.createInputCheck().cast();
    @DataField(value="project-name")
    SpanElement projectName = (SpanElement)DOM.createSpan().cast();
    @DataField(value="tagList")
    Element tagList = DOM.createElement((String)"ul");
    @Inject
    private ManagedInstance<TagItemView> tagItemViewInstance;

    public HandlerRegistration addMouseOutHandler(MouseOutHandler mouseOutHandler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)mouseOutHandler, (GwtEvent.Type)MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler mouseOverHandler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)mouseOverHandler, (GwtEvent.Type)MouseOverEvent.getType());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)handler, ValueChangeEvent.getType());
    }

    @Override
    public void setProject(ExampleProject project, boolean selected) {
        SafeHtmlBuilder shb = new SafeHtmlBuilder();
        shb.appendEscaped(project.getName());
        this.projectName.setInnerSafeHtml(shb.toSafeHtml());
        this.projectSelected.setChecked(selected);
        if (project.getTags() != null) {
            for (String tagName : project.getTags()) {
                TagItemView tagItemView = (TagItemView)this.tagItemViewInstance.get();
                tagItemView.setName(tagName);
                tagItemView.hideCloseIcon();
                com.google.gwt.user.client.Element tagNode = tagItemView.asWidget().getElement();
                this.tagList.appendChild((Node)tagNode);
            }
        }
    }

    @EventHandler(value={"project"})
    public void onProjectMouseOver(MouseOverEvent event) {
        this.fireEvent((GwtEvent)event);
    }

    @EventHandler(value={"project"})
    public void onProjectMouseOut(MouseOutEvent event) {
        this.fireEvent((GwtEvent)event);
    }

    @EventHandler(value={"project-selected"})
    public void onSelectProject(ClickEvent event) {
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.projectSelected.isChecked());
    }
}

