/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.project;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectItemView;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectPageView;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.TagItemView;
import org.kie.workbench.common.screens.examples.model.ExampleProject;

@Dependent
@Templated
public class ProjectPageViewImpl
extends Composite
implements ProjectPageView {
    @DataField
    Element projects = DOM.createDiv();
    @DataField(value="project-description")
    Element projectDescription = DOM.createDiv();
    @Inject
    @DataField(value="tagInput")
    TextInput tagInput;
    @Inject
    @DataField(value="searchButton")
    Button searchButton;
    @DataField(value="tagList")
    Element tagList = DOM.createElement((String)"ul");
    @Inject
    @DataField(value="clear")
    Anchor clear;
    @Inject
    private ManagedInstance<ProjectItemView> projectItemViewInstance;
    @Inject
    private ManagedInstance<TagItemView> tagItemViewInstance;
    private ProjectPage presenter;

    public void init(ProjectPage presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initialise() {
        this.destroy();
    }

    @Override
    public void setProjectsInRepository(List<ExampleProject> projects) {
        this.projects.removeAllChildren();
        for (ExampleProject project : projects) {
            ProjectItemView w = this.makeProjectWidget(project);
            this.projects.appendChild((Node)w.asWidget().getElement());
        }
    }

    @Override
    public void destroy() {
        this.projects.removeAllChildren();
        this.tagInput.setValue("");
        this.tagList.removeAllChildren();
    }

    private ProjectItemView makeProjectWidget(final ExampleProject project) {
        ProjectItemView projectItemView = (ProjectItemView)this.projectItemViewInstance.get();
        projectItemView.setProject(project, this.presenter.isProjectSelected(project));
        projectItemView.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                boolean selected = (Boolean)event.getValue();
                if (selected) {
                    ProjectPageViewImpl.this.presenter.addProject(project);
                } else {
                    ProjectPageViewImpl.this.presenter.removeProject(project);
                }
            }
        });
        projectItemView.addMouseOverHandler(h -> {
            SafeHtmlBuilder shb = new SafeHtmlBuilder();
            shb.appendEscaped(project.getDescription());
            this.projectDescription.setInnerSafeHtml(shb.toSafeHtml());
        });
        projectItemView.addMouseOutHandler(h -> this.projectDescription.setInnerSafeHtml(new SafeHtmlBuilder().toSafeHtml()));
        return projectItemView;
    }

    @EventHandler(value={"searchButton"})
    private void onSearchButtonClicked(ClickEvent event) {
        this.createAndAddTag(false);
    }

    @EventHandler(value={"tagInput"})
    private void onTagInputEnterPressed(KeyUpEvent event) {
        int keyCode = event.getNativeKeyCode();
        if (keyCode == 13) {
            this.createAndAddTag(true);
        } else {
            this.presenter.addPartialTag(this.tagInput.getValue());
            this.tagInput.focus();
        }
    }

    private void createAndAddTag(boolean setTagInputFocus) {
        if (this.tagInput.getValue() != null && !this.tagInput.getValue().isEmpty()) {
            TagItemView tag = (TagItemView)this.tagItemViewInstance.get();
            tag.setName(this.tagInput.getValue());
            com.google.gwt.user.client.Element tagNode = tag.asWidget().getElement();
            tag.addClickHandler(arg_0 -> this.lambda$createAndAddTag$2((Node)tagNode, tag, arg_0));
            this.tagList.appendChild((Node)tagNode);
            this.presenter.addTag(this.tagInput.getValue());
            this.tagInput.setValue("");
            if (setTagInputFocus) {
                this.tagInput.focus();
            }
        }
    }

    @EventHandler(value={"clear"})
    private void onClearClicked(ClickEvent event) {
        this.tagList.removeAllChildren();
        this.presenter.removeAllTags();
    }

    private /* synthetic */ void lambda$createAndAddTag$2(Node tagNode, TagItemView tag, ClickEvent c) {
        this.tagList.removeChild(tagNode);
        this.presenter.removeTag(tag.getName());
    }
}

