/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.model.ExamplesWizardModel;
import org.kie.workbench.common.screens.examples.client.wizard.pages.ExamplesWizardPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.project.ProjectPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.sourcerepository.SourceRepositoryPage;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExamplesMetaData;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;

@Dependent
public class ExamplesWizard
extends AbstractWizard {
    private static final int PREFERRED_WIDTH = 800;
    private static final int PREFERRED_HEIGHT = 800;
    private ExamplesWizardModel model;
    private List<WizardPage> pages = new ArrayList<WizardPage>();
    private SourceRepositoryPage sourceRepositoryPage;
    private BusyIndicatorView busyIndicatorView;
    private Caller<ExamplesService> examplesService;
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    private TranslationService translator;

    public ExamplesWizard() {
    }

    @Inject
    public ExamplesWizard(SourceRepositoryPage sourceRepositoryPage, ProjectPage projectPage, BusyIndicatorView busyIndicatorView, Caller<ExamplesService> examplesService, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, TranslationService translator) {
        this.pages.add(sourceRepositoryPage);
        this.pages.add(projectPage);
        this.sourceRepositoryPage = sourceRepositoryPage;
        this.busyIndicatorView = busyIndicatorView;
        this.examplesService = examplesService;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.translator = translator;
        this.model = new ExamplesWizardModel();
    }

    public void start() {
        for (WizardPage page : this.pages) {
            page.initialise();
            ((ExamplesWizardPage)page).setModel(this.model);
        }
        ((ExamplesService)this.examplesService.call((RemoteCallback)new RemoteCallback<ExamplesMetaData>(){

            public void callback(ExamplesMetaData metaData) {
                ExampleRepository repository = metaData.getRepository();
                ExamplesWizard.this.sourceRepositoryPage.setPlaygroundRepository(repository);
                ExamplesWizard.super.start();
            }
        })).getMetaData();
    }

    public void close() {
        for (WizardPage page : this.pages) {
            ((ExamplesWizardPage)page).destroy();
        }
        super.close();
    }

    public List<WizardPage> getPages() {
        return this.pages;
    }

    public Widget getPageWidget(int pageNumber) {
        WizardPage page = this.pages.get(pageNumber);
        page.prepareView();
        return page.asWidget();
    }

    ExamplesWizardModel getModel() {
        return this.model;
    }

    public String getTitle() {
        String title = this.translator.format("ExamplesWizard.WizardTitle", new Object[0]);
        return title != null && !title.isEmpty() ? title : "Import Example";
    }

    public int getPreferredHeight() {
        return 800;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void isComplete(final Callback<Boolean> callback) {
        callback.callback((Object)true);
        for (WizardPage page : this.pages) {
            page.isComplete((Callback)new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (Boolean.FALSE.equals(result)) {
                        callback.callback((Object)false);
                    }
                }
            });
        }
    }

    public void complete() {
        this.busyIndicatorView.showBusyIndicator(this.translator.format("ExamplesWizard.SettingUpExamples", new Object[0]));
        ((ExamplesService)this.examplesService.call((RemoteCallback)new RemoteCallback<WorkspaceProjectContextChangeEvent>(){

            public void callback(WorkspaceProjectContextChangeEvent context) {
                ExamplesWizard.this.busyIndicatorView.hideBusyIndicator();
                ExamplesWizard.super.complete();
                ExamplesWizard.this.projectContextChangeEvent.fire((Object)context);
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).setupExamples(this.model.getTargetOrganizationalUnit(), this.model.getProjects());
    }

    public void setDefaultTargetOrganizationalUnit(String ouName) {
        ExampleOrganizationalUnit targetOrganizationalUnit = new ExampleOrganizationalUnit(ouName);
        this.model.setTargetOrganizationalUnit(targetOrganizationalUnit);
    }
}

