/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.repository;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.dom.RadioInput;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.client.wizard.pages.repository.RepositoryPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.repository.RepositoryPageView;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;

@Dependent
@Templated
public class RepositoryPageViewImpl
extends Composite
implements RepositoryPageView {
    @DataField(value="repository-type")
    Element repositoryType = DOM.createDiv();
    @Inject
    @DataField(value="stockRadio")
    RadioInput stockRadio;
    @Inject
    @DataField(value="customRadio")
    RadioInput customRadio;
    @DataField(value="repository-form")
    Element repositoryGroup = DOM.createDiv();
    @Inject
    @DataField(value="repositoryUrlInput")
    TextInput repositoryUrlInput;
    @DataField(value="repository-help")
    Element repositoryHelp = DOM.createSpan();
    private RepositoryPage presenter;

    public void init(RepositoryPage presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initialise() {
        this.repositoryUrlInput.setValue("");
    }

    @Override
    public void setPlaceHolder(String placeHolder) {
        this.repositoryUrlInput.setAttribute("placeholder", placeHolder);
    }

    @Override
    public void setUrlGroupType(ValidationState state) {
        StyleHelper.addUniqueEnumStyleName((Element)this.repositoryGroup, ValidationState.class, (Style.HasCssName)state);
    }

    @Override
    public void showUrlHelpMessage(String message) {
        this.repositoryHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.repositoryHelp.setInnerText(message);
    }

    @Override
    public void hideUrlHelpMessage() {
        this.repositoryHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.repositoryHelp.setInnerText("");
    }

    @Override
    public void setStockRepositoryOption() {
        this.stockRadio.setChecked(true);
        this.customRadio.setChecked(false);
    }

    @Override
    public void disableStockRepositoryOption() {
        this.stockRadio.setDisabled(true);
    }

    @Override
    public void setCustomRepositoryOption() {
        this.customRadio.setChecked(true);
        this.stockRadio.setChecked(false);
    }

    @Override
    public void showRepositoryUrlInputForm() {
        this.repositoryGroup.getStyle().setVisibility(Style.Visibility.VISIBLE);
    }

    @Override
    public void hideRepositoryUrlInputForm() {
        this.repositoryGroup.getStyle().setVisibility(Style.Visibility.HIDDEN);
    }

    @Override
    public String getCustomRepositoryValue() {
        return this.repositoryUrlInput.getValue();
    }

    @Override
    public void setCustomRepositoryValue(String value) {
        this.repositoryUrlInput.setValue(value);
    }

    @EventHandler(value={"stockRadio"})
    public void handleStockRadioClick(ClickEvent event) {
        this.presenter.playgroundRepositorySelected();
    }

    @EventHandler(value={"customRadio"})
    public void handleCustomRadioClick(ClickEvent event) {
        this.presenter.onCustomRepositorySelected();
    }

    @EventHandler(value={"repositoryUrlInput"})
    public void handleRepositoryUrlInputValueChange(ChangeEvent event) {
        this.presenter.onCustomRepositoryValueChanged();
    }
}

