/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.client.wizard.pages.targetrepository;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.pages.BaseExamplesWizardPage;
import org.kie.workbench.common.screens.examples.client.wizard.pages.targetrepository.TargetRepositoryPageView;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleTargetRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class TargetRepositoryPage
extends BaseExamplesWizardPage
implements TargetRepositoryPageView.Presenter {
    private TargetRepositoryPageView view;

    public TargetRepositoryPage() {
    }

    @Inject
    public TargetRepositoryPage(TargetRepositoryPageView view, TranslationService translator, Caller<ExamplesService> examplesService, Event<WizardPageStatusChangeEvent> pageStatusChangedEvent) {
        super(translator, examplesService, pageStatusChangedEvent);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setTargetRepositoryPlaceHolder(this.translator.format("TargetRepositoryPage.WizardTargetRepositoryPlaceHolder", new Object[0]));
    }

    public void initialise() {
        this.view.initialise();
    }

    public String getTitle() {
        return this.translator.format("TargetRepositoryPage.WizardTargetRepositoryPageTitle", new Object[0]);
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void isComplete(final Callback<Boolean> callback) {
        ExampleTargetRepository targetRepository = this.model.getTargetRepository();
        this.validateOrganizationalUnit(targetRepository, new Callback<Boolean>(){

            public void callback(Boolean result) {
                callback.callback((Object)result);
            }
        });
    }

    private List<ExampleOrganizationalUnit> sort(Set<ExampleOrganizationalUnit> repositories) {
        ArrayList<ExampleOrganizationalUnit> sortedRepositories = new ArrayList<ExampleOrganizationalUnit>(repositories);
        Collections.sort(sortedRepositories, new Comparator<ExampleOrganizationalUnit>(){

            @Override
            public int compare(ExampleOrganizationalUnit o1, ExampleOrganizationalUnit o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedRepositories;
    }

    @Override
    public void setTargetRepository(ExampleTargetRepository repository) {
        this.model.setTargetRepository(repository);
        this.view.setTargetRepository(repository);
        this.pageStatusChangedEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    private void validateOrganizationalUnit(ExampleTargetRepository targetRepository, final Callback<Boolean> callback) {
        boolean isValid = true;
        if (targetRepository == null) {
            this.view.setTargetRepositoryGroupType(ValidationState.ERROR);
            this.view.showTargetRepositoryHelpMessage(this.translator.format("TargetRepositoryPage.WizardSelectTargetRepositoryMandatory", new Object[0]));
            callback.callback((Object)false);
        } else {
            String targetRepositoryName = targetRepository.getAlias();
            if (targetRepositoryName == null || targetRepositoryName.trim().isEmpty()) {
                this.view.setTargetRepositoryGroupType(ValidationState.ERROR);
                this.view.showTargetRepositoryHelpMessage(this.translator.format("TargetRepositoryPage.WizardSelectTargetRepositoryMandatory", new Object[0]));
                callback.callback((Object)false);
            } else {
                final boolean _isValid = isValid;
                ((ExamplesService)this.examplesService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                    public void callback(Boolean valid) {
                        if (Boolean.TRUE.equals(valid)) {
                            TargetRepositoryPage.this.view.setTargetRepositoryGroupType(ValidationState.NONE);
                            TargetRepositoryPage.this.view.hideTargetRepositoryHelpMessage();
                        } else {
                            TargetRepositoryPage.this.view.setTargetRepositoryGroupType(ValidationState.ERROR);
                            TargetRepositoryPage.this.view.showTargetRepositoryHelpMessage(TargetRepositoryPage.this.translator.format("TargetRepositoryPage.WizardSelectTargetRepositoryInvalid", new Object[0]));
                        }
                        callback.callback((Object)(valid != false && _isValid ? 1 : 0));
                    }
                })).validateRepositoryName(targetRepositoryName);
            }
        }
    }
}

