/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.home.client.widgets.home;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.home.client.resources.HomeResources;
import org.kie.workbench.common.screens.home.client.widgets.carousel.CarouselEntryWidget;
import org.kie.workbench.common.screens.home.client.widgets.carousel.CarouselWidget;
import org.kie.workbench.common.screens.home.client.widgets.home.HomePresenter;
import org.kie.workbench.common.screens.home.client.widgets.sections.VerticalSectionWidget;
import org.kie.workbench.common.screens.home.model.CarouselEntry;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.Section;
import org.kie.workbench.common.screens.home.model.SectionEntry;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

public class HomeViewImpl
extends Composite
implements HomePresenter.HomeView {
    private static HomeViewImplBinder uiBinder = (HomeViewImplBinder)GWT.create(HomeViewImplBinder.class);
    private HomePresenter presenter;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private RuntimeAuthorizationManager authzManager;
    @Inject
    private User identity;
    @UiField
    CarouselWidget carousel;
    @UiField
    HeadingElement title;
    @UiField
    HorizontalPanel columns;

    public HomeViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(HomePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setModel(HomeModel model) {
        if (model == null) {
            return;
        }
        for (int index = 0; index < model.getCarouselEntries().size(); ++index) {
            CarouselEntry entry = (CarouselEntry)model.getCarouselEntries().get(index);
            this.carousel.addCarouselEntry(this.makeCarouselEntry(entry.getHeading(), entry.getSubHeading(), entry.getImageUrl(), index == 0));
        }
        this.title.setInnerText(SafeHtmlUtils.htmlEscape((String)model.getTitle()));
        for (Section section : model.getSections()) {
            if (!this.authzManager.authorize((Resource)section, this.identity) || !this.doesSectionContainAuthorizedEntries(section)) continue;
            VerticalSectionWidget vs = new VerticalSectionWidget();
            vs.setHeaderText(section.getHeading());
            for (SectionEntry sectionEntry : section.getEntries()) {
                if (!this.authzManager.authorize((Resource)sectionEntry, this.identity)) continue;
                vs.add(this.makeSectionEntry(sectionEntry.getCaption(), sectionEntry.getOnClickCommand()));
            }
            vs.addStyleName("well");
            this.columns.add((Widget)vs);
        }
        int cols = this.columns.getWidgetCount();
        int colSize = cols > 0 ? 1170 / cols : 1170;
        int index = 0;
        for (Widget widget : this.columns) {
            widget.setWidth((index < cols - 1 ? colSize - 4 : colSize) + "px");
            ++index;
        }
    }

    private boolean doesSectionContainAuthorizedEntries(Section section) {
        for (SectionEntry sectionEntry : section.getEntries()) {
            if (!this.authzManager.authorize((Resource)sectionEntry, this.identity)) continue;
            return true;
        }
        return false;
    }

    private CarouselEntryWidget makeCarouselEntry(String heading, String subHeading, String imageUri, boolean active) {
        CarouselEntryWidget item = new CarouselEntryWidget();
        item.setHeading(SafeHtmlUtils.fromString((String)heading));
        item.setSubHeading(SafeHtmlUtils.fromString((String)subHeading));
        item.setImageUri(UriUtils.fromString((String)imageUri));
        item.setActive(active);
        return item;
    }

    private Widget makeSectionEntry(String caption, final Command command) {
        Anchor anchor = new Anchor(caption);
        anchor.setStyleName(HomeResources.INSTANCE.CSS().sectionBody());
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                command.execute();
            }
        });
        return anchor;
    }

    static interface HomeViewImplBinder
    extends UiBinder<Widget, HomeViewImpl> {
    }
}

