/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.home.client.widgets.home;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Heading;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.home.client.resources.HomeResources;
import org.kie.workbench.common.screens.home.client.widgets.carousel.CarouselEntryWidget;
import org.kie.workbench.common.screens.home.client.widgets.carousel.CarouselWidget;
import org.kie.workbench.common.screens.home.client.widgets.home.HomePresenter;
import org.kie.workbench.common.screens.home.client.widgets.sections.VerticalSectionWidget;
import org.kie.workbench.common.screens.home.model.CarouselEntry;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.SectionEntry;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.AuthorizationManager;

public class HomeViewImpl
extends Composite
implements HomePresenter.HomeView {
    private static HomeViewImplBinder uiBinder = (HomeViewImplBinder)GWT.create(HomeViewImplBinder.class);
    private HomePresenter presenter;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    @UiField
    CarouselWidget carousel;
    @UiField
    Heading title;
    @UiField
    HorizontalPanel columns;

    public HomeViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(HomePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setModel(HomeModel model) {
        if (model == null) {
            return;
        }
        for (int index = 0; index < model.getCarouselEntries().size(); ++index) {
            CarouselEntry entry = (CarouselEntry)model.getCarouselEntries().get(index);
            this.carousel.addCarouselEntry(this.makeCarouselEntry(entry.getHeading(), entry.getSubHeading(), entry.getImageUrl(), index == 0));
        }
        this.title.setText(SafeHtmlUtils.htmlEscape((String)model.getTitle()));
        for (SectionEntry section : model.getSections()) {
            if (!this.authorize(section) || !this.doesSectionContainAuthorizedEntries(section)) continue;
            VerticalSectionWidget vs = new VerticalSectionWidget();
            vs.setHeaderText(section.getCaption());
            for (SectionEntry sectionEntry : section.getChildren()) {
                if (!this.authorize(sectionEntry)) continue;
                vs.add(this.makeSectionEntry(sectionEntry.getCaption(), sectionEntry.getOnClickCommand()));
            }
            vs.addStyleName("well");
            this.columns.add((Widget)vs);
        }
        int cols = this.columns.getWidgetCount();
        int colSize = cols > 0 ? 1140 / cols : 1140;
        int index = 0;
        for (Widget widget : this.columns) {
            widget.setWidth((index < cols - 1 ? colSize - 4 : colSize) + "px");
            ++index;
        }
    }

    private boolean authorize(SectionEntry section) {
        if (section.getResource() != null) {
            return this.authzManager.authorize(section.getResource(), section.getResourceAction(), this.identity);
        }
        if (section.getPermission() != null) {
            return this.authzManager.authorize(section.getPermission(), this.identity);
        }
        return true;
    }

    private boolean doesSectionContainAuthorizedEntries(SectionEntry section) {
        for (SectionEntry sectionEntry : section.getChildren()) {
            if (!this.authorize(sectionEntry)) continue;
            return true;
        }
        return false;
    }

    private CarouselEntryWidget makeCarouselEntry(String heading, String subHeading, String imageUri, boolean active) {
        CarouselEntryWidget item = (CarouselEntryWidget)((Object)GWT.create(CarouselEntryWidget.class));
        item.setHeading(SafeHtmlUtils.fromString((String)heading));
        item.setSubHeading(SafeHtmlUtils.fromString((String)subHeading));
        item.setImageUri(UriUtils.fromString((String)imageUri));
        item.setActive(active);
        return item;
    }

    private Widget makeSectionEntry(String caption, Command command) {
        Anchor anchor = new Anchor(caption);
        anchor.setStyleName(HomeResources.INSTANCE.CSS().sectionBody());
        anchor.addClickHandler(e -> command.execute());
        return anchor;
    }

    static interface HomeViewImplBinder
    extends UiBinder<Widget, HomeViewImpl> {
    }
}

