/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.home.client.widgets.home;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.ShortcutPresenter;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.HomeModelProvider;
import org.kie.workbench.common.screens.home.model.HomeShortcut;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.security.authz.AuthorizationManager;

@Dependent
@WorkbenchScreen(identifier="org.kie.workbench.common.screens.home.client.HomePresenter")
public class HomePresenter {
    private View view;
    private TranslationService translationService;
    private HomeModelProvider modelProvider;
    private AuthorizationManager authorizationManager;
    private User user;
    private ManagedInstance<ShortcutPresenter> shortcutPresenters;

    @Inject
    public HomePresenter(View view, TranslationService translationService, HomeModelProvider modelProvider, AuthorizationManager authorizationManager, User user, ManagedInstance<ShortcutPresenter> shortcutPresenters) {
        this.view = view;
        this.translationService = translationService;
        this.modelProvider = modelProvider;
        this.authorizationManager = authorizationManager;
        this.user = user;
        this.shortcutPresenters = shortcutPresenters;
    }

    public void setup() {
        HomeModel model = this.modelProvider.get();
        this.view.setWelcome(model.getWelcome());
        this.view.setDescription(model.getDescription());
        this.view.setBackgroundImageUrl(model.getBackgroundImageUrl());
        model.getShortcuts().forEach(shortcut -> {
            if (this.authorize((HomeShortcut)shortcut)) {
                ShortcutPresenter shortcutPresenter = (ShortcutPresenter)this.shortcutPresenters.get();
                shortcutPresenter.setup((HomeShortcut)shortcut);
                this.view.addShortcut(shortcutPresenter);
            }
        });
    }

    private boolean authorize(HomeShortcut shortcut) {
        if (shortcut.getResource() != null) {
            return this.authorizationManager.authorize(shortcut.getResource(), shortcut.getResourceAction(), this.user);
        }
        if (shortcut.getPermission() != null) {
            return this.authorizationManager.authorize(shortcut.getPermission(), this.user);
        }
        return true;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("homeName", new Object[0]);
    }

    @WorkbenchPartView
    public UberElement<HomePresenter> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<HomePresenter> {
        public void setWelcome(String var1);

        public void setDescription(String var1);

        public void setBackgroundImageUrl(String var1);

        public void addShortcut(ShortcutPresenter var1);
    }
}

