/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.home.client.widgets.shortcut.utils;

import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.home.model.HomeShortcut;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

public class ShortcutHelper {
    private AuthorizationManager authorizationManager;
    private User user;
    private PlaceManager placeManager;

    public ShortcutHelper() {
    }

    @Inject
    public ShortcutHelper(AuthorizationManager authorizationManager, User user, PlaceManager placeManager) {
        this.authorizationManager = authorizationManager;
        this.user = user;
        this.placeManager = placeManager;
    }

    public String getPart(String text, int part) {
        if (part < 1) {
            throw new RuntimeException("The first part is the number one.");
        }
        int beginIndex = 0;
        if (part > 1) {
            int i = part - 2;
            String s = "{" + i + "}";
            beginIndex = text.indexOf(s);
            if (beginIndex < 0) {
                throw new RuntimeException("The translation " + text + " is missing parameters.");
            }
            beginIndex += String.valueOf(i).length() + 2;
        }
        int i2 = part - 1;
        String s2 = "{" + i2 + "}";
        int endIndex = text.indexOf(s2);
        if (endIndex < 0) {
            endIndex = text.length();
        }
        return text.substring(beginIndex, endIndex);
    }

    public void goTo(String perspectiveIdentifier) {
        if (this.authorize(perspectiveIdentifier)) {
            this.placeManager.goTo(perspectiveIdentifier);
        }
    }

    public boolean authorize(String perspective) {
        return this.authorizationManager.authorize((Resource)new ResourceRef(perspective, (ResourceType)ActivityResourceType.PERSPECTIVE), this.user);
    }

    public boolean authorize(HomeShortcut shortcut) {
        if (shortcut.getResource() != null) {
            return this.authorizationManager.authorize(shortcut.getResource(), shortcut.getResourceAction(), this.user);
        }
        if (shortcut.getPermission() != null) {
            return this.authorizationManager.authorize(shortcut.getPermission(), this.user);
        }
        return true;
    }
}

