/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.home.client.widgets.home;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.profile.api.preferences.ProfilePreferences;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.ShortcutPresenter;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.HomeModelProvider;
import org.kie.workbench.common.screens.home.model.HomeShortcut;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;

@Dependent
@WorkbenchScreen(identifier="org.kie.workbench.common.screens.home.client.HomePresenter")
public class HomePresenter {
    private View view;
    private TranslationService translationService;
    private HomeModelProvider modelProvider;
    private ManagedInstance<ShortcutPresenter> shortcutPresenters;
    ProfilePreferences profilePreferences;

    @Inject
    public HomePresenter(View view, TranslationService translationService, HomeModelProvider modelProvider, ManagedInstance<ShortcutPresenter> shortcutPresenters, ProfilePreferences profilePreferences) {
        this.view = view;
        this.translationService = translationService;
        this.modelProvider = modelProvider;
        this.shortcutPresenters = shortcutPresenters;
        this.profilePreferences = profilePreferences;
    }

    public void setup() {
        this.profilePreferences.load(loadedProfilePreferences -> {
            HomeModel model = this.modelProvider.get(loadedProfilePreferences);
            this.view.setWelcome(model.getWelcome());
            this.view.setDescription(model.getDescription());
            this.view.setBackgroundImageUrl(model.getBackgroundImageUrl());
            model.getShortcuts().forEach(shortcut -> {
                ShortcutPresenter shortcutPresenter = (ShortcutPresenter)this.shortcutPresenters.get();
                shortcutPresenter.setup((HomeShortcut)shortcut);
                this.view.addShortcut(shortcutPresenter);
            });
        }, RuntimeException::new);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("homeName", new Object[0]);
    }

    @WorkbenchPartView
    public UberElement<HomePresenter> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<HomePresenter> {
        public void setWelcome(String var1);

        public void setDescription(String var1);

        public void setBackgroundImageUrl(String var1);

        public void addShortcut(ShortcutPresenter var1);
    }
}

