/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.home.client.widgets.shortcut;

import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.subheading.ShortcutSubHeadingLinkPresenter;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.subheading.ShortcutSubHeadingTextPresenter;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.utils.ShortcutHelper;
import org.kie.workbench.common.screens.home.model.HomeShortcut;
import org.kie.workbench.common.screens.home.model.HomeShortcutLink;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

public class ShortcutPresenter {
    private View view;
    private ShortcutHelper shortcutHelper;
    private ManagedInstance<ShortcutSubHeadingLinkPresenter> linkPresenters;
    private ManagedInstance<ShortcutSubHeadingTextPresenter> textPresenters;

    @Inject
    public ShortcutPresenter(View view, ShortcutHelper shortcutHelper, ManagedInstance<ShortcutSubHeadingLinkPresenter> linkPresenters, ManagedInstance<ShortcutSubHeadingTextPresenter> textPresenters) {
        this.view = view;
        this.shortcutHelper = shortcutHelper;
        this.linkPresenters = linkPresenters;
        this.textPresenters = textPresenters;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(HomeShortcut shortcut) {
        this.setupIcon(shortcut);
        this.view.setHeading(shortcut.getHeading());
        this.setupAction(shortcut);
        this.setupSubHeading(shortcut);
    }

    private void setupIcon(HomeShortcut shortcut) {
        String iconClass = shortcut.getIconCss();
        if (iconClass != null && !iconClass.isEmpty()) {
            Stream.of(iconClass.split(" ")).forEach(clazz -> this.view.addIconClass((String)clazz));
        }
    }

    private void setupSubHeading(HomeShortcut shortcut) {
        int part = 1;
        this.addText(shortcut.getSubHeading(), part);
        for (HomeShortcutLink link : shortcut.getLinks()) {
            this.addLink(link);
            this.addText(shortcut.getSubHeading(), ++part);
        }
    }

    private void setupAction(HomeShortcut shortcut) {
        if (this.shortcutHelper.authorize(shortcut)) {
            this.view.setAction(shortcut.getOnClickCommand());
        }
    }

    private void addText(String subHeading, int part) {
        ShortcutSubHeadingTextPresenter textPresenter = (ShortcutSubHeadingTextPresenter)this.textPresenters.get();
        textPresenter.setup(subHeading, part);
        this.view.addSubHeadingChild((IsElement)textPresenter.getView());
    }

    private void addLink(HomeShortcutLink link) {
        ShortcutSubHeadingLinkPresenter linkPresenter = (ShortcutSubHeadingLinkPresenter)this.linkPresenters.get();
        linkPresenter.setup(link);
        this.view.addSubHeadingChild((IsElement)linkPresenter.getView());
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<ShortcutPresenter> {
        public void addIconClass(String var1);

        public void setHeading(String var1);

        public void setAction(Command var1);

        public void addSubHeadingChild(IsElement var1);
    }
}

