/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.kie.workbench.common.screens.library.api.index.LibraryFileExtensionIndexTerm;
import org.kie.workbench.common.screens.library.api.index.LibraryValueFileNameIndexTerm;
import org.kie.workbench.common.screens.library.api.index.LibraryValueRepositoryRootIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.FileDetailsResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindAllLibraryAssetsQuery
extends AbstractFindQuery
implements NamedQuery {
    public static String NAME = "FindAllLibraryAssetsQuery";
    @Inject
    private FileDetailsResponseBuilder responseBuilder;

    public String getName() {
        return NAME;
    }

    public Query toQuery(Set<ValueIndexTerm> terms) {
        this.checkNotNullAndNotEmpty(terms);
        Query query = this.buildFromMultipleTerms(terms);
        return query;
    }

    public Sort getSortOrder() {
        return new Sort(new SortField("filenamesorted", SortField.Type.STRING));
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{"libraryRepositoryRoot", null, null}, new Predicate[]{t -> t instanceof LibraryValueRepositoryRootIndexTerm, t -> t instanceof LibraryValueFileNameIndexTerm, t -> t instanceof LibraryFileExtensionIndexTerm});
        this.checkTermsSize(3, queryTerms);
    }
}

