/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExampleTargetRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.impl.FindAllLibraryAssetsQuery;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.api.index.LibraryValueFileNameIndexTerm;
import org.kie.workbench.common.screens.library.api.index.LibraryValueProjectRootPathIndexTerm;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferences;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.paging.PageResponse;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class LibraryServiceImpl
implements LibraryService {
    private static final Logger log = LoggerFactory.getLogger(LibraryServiceImpl.class);
    private RefactoringQueryService refactoringQueryService;
    private OrganizationalUnitService ouService;
    private RepositoryService repositoryService;
    private KieProjectService kieProjectService;
    private LibraryPreferences preferences;
    private LibraryInternalPreferences internalPreferences;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private ExplorerServiceHelper explorerServiceHelper;
    private KieProjectService projectService;
    private ExamplesService examplesService;
    private IOService ioService;

    public LibraryServiceImpl() {
    }

    @Inject
    public LibraryServiceImpl(OrganizationalUnitService ouService, RepositoryService repositoryService, KieProjectService kieProjectService, RefactoringQueryService refactoringQueryService, LibraryPreferences preferences, AuthorizationManager authorizationManager, SessionInfo sessionInfo, ExplorerServiceHelper explorerServiceHelper, KieProjectService projectService, ExamplesService examplesService, @Named(value="ioStrategy") IOService ioService, LibraryInternalPreferences internalPreferences) {
        this.ouService = ouService;
        this.repositoryService = repositoryService;
        this.kieProjectService = kieProjectService;
        this.refactoringQueryService = refactoringQueryService;
        this.preferences = preferences;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.explorerServiceHelper = explorerServiceHelper;
        this.projectService = projectService;
        this.examplesService = examplesService;
        this.ioService = ioService;
        this.internalPreferences = internalPreferences;
    }

    public OrganizationalUnitRepositoryInfo getDefaultOrganizationalUnitRepositoryInfo() {
        return this.getOrganizationalUnitRepositoryInfo(this.getDefaultOrganizationalUnit());
    }

    public OrganizationalUnitRepositoryInfo getOrganizationalUnitRepositoryInfo(OrganizationalUnit selectedOrganizationalUnit) {
        if (selectedOrganizationalUnit == null) {
            return null;
        }
        Repository selectedRepository = this.getDefaultRepository(selectedOrganizationalUnit);
        List<OrganizationalUnit> organizationalUnits = this.getOrganizationalUnits();
        OrganizationalUnit organizationalUnit = this.getOrganizationalUnit(selectedOrganizationalUnit.getIdentifier(), organizationalUnits).get();
        ArrayList repositories = new ArrayList(organizationalUnit.getRepositories());
        return new OrganizationalUnitRepositoryInfo(organizationalUnits, organizationalUnit, repositories, selectedRepository);
    }

    public LibraryInfo getLibraryInfo(Repository selectedRepository, String branch) {
        List<Project> projects = this.getProjects(selectedRepository, branch);
        return new LibraryInfo(branch, projects);
    }

    public KieProject createProject(String projectName, OrganizationalUnit selectedOrganizationalUnit, Repository selectedRepository, String baseURL, String projectDescription) {
        Path selectedRepositoryRootPath = selectedRepository.getRoot();
        LibraryPreferences preferences = this.getPreferences();
        GAV gav = this.createGAV(projectName, preferences, selectedOrganizationalUnit);
        POM pom = this.createPOM(projectName, projectDescription, gav);
        DeploymentMode mode = DeploymentMode.VALIDATED;
        KieProject kieProject = (KieProject)this.kieProjectService.newProject(selectedRepositoryRootPath, pom, baseURL, mode);
        return kieProject;
    }

    public Boolean thereIsAProjectInTheWorkbench() {
        return this.getOrganizationalUnits().stream().flatMap(organizationalUnit -> organizationalUnit.getRepositories().stream().filter(repository -> this.authorizationManager.authorize((Resource)repository, this.sessionInfo.getIdentity()))).flatMap(repository -> repository.getBranches().stream().map(branch -> this.kieProjectService.getProjects(repository, branch))).anyMatch(projects -> projects != null && !projects.isEmpty());
    }

    public List<AssetInfo> getProjectAssets(ProjectAssetsQuery query) {
        PortablePreconditions.checkNotNull((String)"query", (Object)query);
        boolean projectStillExists = this.ioService.exists(Paths.convert((Path)query.getProject().getRootPath()));
        if (!projectStillExists) {
            return Collections.emptyList();
        }
        HashSet<Object> queryTerms = new HashSet<Object>();
        queryTerms.add(new LibraryValueProjectRootPathIndexTerm(query.getProject().getRootPath().toURI()));
        if (query.hasFilter()) {
            queryTerms.add(new LibraryValueFileNameIndexTerm("*" + query.getFilter() + "*", ValueIndexTerm.TermSearchType.WILDCARD));
        }
        PageResponse findRulesByProjectQuery = this.refactoringQueryService.query(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, query.getStartIndex(), Integer.valueOf(query.getAmount())));
        List assets = findRulesByProjectQuery.getPageRowList().stream().map(row -> {
            Path path = (Path)row.getValue();
            return new FolderItem((Object)path, path.getFileName(), FolderItemType.FILE, false, Paths.readLockedBy((Path)path), Collections.emptyList(), this.explorerServiceHelper.getRestrictedOperations(path));
        }).collect(Collectors.toList());
        return assets.stream().map(asset -> {
            AssetInfo info = null;
            try {
                Map attributes = this.ioService.readAttributes(Paths.convert((Path)((Path)asset.getItem())));
                FileTime lastModifiedFileTime = (FileTime)this.getAttribute("lastModifiedTime", attributes).get();
                FileTime createdFileTime = (FileTime)this.getAttribute("creationTime", attributes).get();
                Date lastModifiedTime = new Date(lastModifiedFileTime.toMillis());
                Date createdTime = new Date(createdFileTime.toMillis());
                info = new AssetInfo(asset, lastModifiedTime, createdTime);
            }
            catch (NoSuchFileException nfe) {
                log.debug("File '" + asset.getFileName() + "' in LibraryIndex but not VFS. Suspected deletion. Skipping.");
            }
            return Optional.ofNullable(info);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Boolean hasProjects(Repository repository, String branch) {
        return !this.getProjects(repository, branch).isEmpty();
    }

    public Boolean hasAssets(Project project) {
        PortablePreconditions.checkNotNull((String)"project", (Object)project);
        Package defaultPackage = this.projectService.resolveDefaultPackage(project);
        return this.explorerServiceHelper.hasAssets(defaultPackage);
    }

    public Set<ExampleProject> getExampleProjects() {
        String importProjectsUrl = this.getPreferences().getImportProjectsUrl();
        ExampleRepository repository = importProjectsUrl == null || importProjectsUrl.isEmpty() ? this.examplesService.getPlaygroundRepository() : new ExampleRepository(importProjectsUrl);
        return this.examplesService.getProjects(repository);
    }

    public Project importProject(ExampleProject exampleProject) {
        OrganizationalUnit ou = this.getDefaultOrganizationalUnit();
        return this.importProject(ou, this.getDefaultRepository(ou), "master", exampleProject);
    }

    public Project importProject(OrganizationalUnit organizationalUnit, Repository repository, String branch, ExampleProject exampleProject) {
        ExampleOrganizationalUnit exampleOrganizationalUnit = new ExampleOrganizationalUnit(organizationalUnit.getName());
        ExampleTargetRepository exampleRepository = new ExampleTargetRepository(repository.getAlias());
        List<ExampleProject> exampleProjects = Collections.singletonList(exampleProject);
        ProjectContextChangeEvent projectContextChangeEvent = this.examplesService.setupExamples(exampleOrganizationalUnit, exampleRepository, branch, exampleProjects);
        return projectContextChangeEvent.getProject();
    }

    public List<OrganizationalUnit> getOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.ouService.getOrganizationalUnits());
    }

    LibraryPreferences getPreferences() {
        this.preferences.load();
        return this.preferences;
    }

    LibraryInternalPreferences getInternalPreferences() {
        this.internalPreferences.load();
        return this.internalPreferences;
    }

    POM createPOM(String projectName, String projectDescription, GAV gav) {
        return new POM(projectName, projectDescription, gav);
    }

    GAV createGAV(String projectName, LibraryPreferences preferences, OrganizationalUnit selectedOrganizationalUnit) {
        return new GAV(selectedOrganizationalUnit.getDefaultGroupId(), projectName.replace(" ", ""), preferences.getProjectPreferences().getVersion());
    }

    private Optional<Object> getAttribute(String attribute, Map<String, Object> attributes) {
        return attributes.entrySet().stream().filter(entry -> attribute.equals(entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    private List<Project> getProjects(Repository repository, String branch) {
        return new ArrayList<Project>(this.kieProjectService.getProjects(repository, branch));
    }

    private OrganizationalUnit getDefaultOrganizationalUnit() {
        List<OrganizationalUnit> organizationalUnits;
        Optional<OrganizationalUnit> defaultOU;
        String defaultOUIdentifier = this.getInternalPreferences().getLastOpenedOrganizationalUnit();
        if (defaultOUIdentifier == null || defaultOUIdentifier.isEmpty()) {
            defaultOUIdentifier = this.getPreferences().getOrganizationalUnitPreferences().getName();
        }
        if ((defaultOU = this.getOrganizationalUnit(defaultOUIdentifier, organizationalUnits = this.getOrganizationalUnits())).isPresent()) {
            return defaultOU.get();
        }
        if (!organizationalUnits.isEmpty()) {
            return organizationalUnits.get(0);
        }
        return this.createDefaultOrganizationalUnit();
    }

    private Repository getDefaultRepository(OrganizationalUnit ou) {
        String lastOpenedRepositoryName = this.getInternalPreferences().getLastOpenedRepository();
        String primaryDefaultRepositoryName = this.getPrimaryDefaultRepositoryName(ou);
        String secondaryDefaultRepositoryName = this.getSecondaryDefaultRepositoryName(ou);
        ArrayList<Repository> repositories = new ArrayList<Repository>(ou.getRepositories());
        Optional<Repository> lastOpenedRepository = this.getRepositoryByName(lastOpenedRepositoryName, repositories);
        Optional<Repository> primaryRepository = this.getRepositoryByName(primaryDefaultRepositoryName, repositories);
        Optional<Repository> secondaryRepository = this.getRepositoryByName(secondaryDefaultRepositoryName, repositories);
        if (lastOpenedRepository.isPresent()) {
            return lastOpenedRepository.get();
        }
        if (primaryRepository.isPresent()) {
            return primaryRepository.get();
        }
        if (secondaryRepository.isPresent()) {
            return secondaryRepository.get();
        }
        if (!repositories.isEmpty()) {
            return (Repository)repositories.get(0);
        }
        if (this.repositoryService.getRepository(primaryDefaultRepositoryName) == null) {
            return this.createDefaultRepository(ou, primaryDefaultRepositoryName);
        }
        if (this.repositoryService.getRepository(secondaryDefaultRepositoryName) == null) {
            return this.createDefaultRepository(ou, secondaryDefaultRepositoryName);
        }
        int i = 1;
        while (this.repositoryService.getRepository(secondaryDefaultRepositoryName + "-" + ++i) != null) {
        }
        return this.createDefaultRepository(ou, secondaryDefaultRepositoryName + "-" + i);
    }

    private Optional<Repository> getRepositoryByName(String lastOpenedRepositoryName, List<Repository> repositories) {
        return repositories.stream().filter(r -> r.getAlias().equalsIgnoreCase(lastOpenedRepositoryName)).findAny();
    }

    private OrganizationalUnit createDefaultOrganizationalUnit() {
        if (!this.authorizationManager.authorize((ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)OrganizationalUnitAction.CREATE, this.sessionInfo.getIdentity())) {
            return null;
        }
        LibraryPreferences preferences = this.getPreferences();
        return this.ouService.createOrganizationalUnit(preferences.getOrganizationalUnitPreferences().getName(), preferences.getOrganizationalUnitPreferences().getOwner(), preferences.getOrganizationalUnitPreferences().getGroupId());
    }

    private Repository createDefaultRepository(OrganizationalUnit ou, String repositoryName) {
        String scheme = this.getPreferences().getRepositoryPreferences().getScheme();
        RepositoryEnvironmentConfigurations configuration = this.getDefaultRepositoryEnvironmentConfigurations();
        return this.repositoryService.createRepository(ou, scheme, repositoryName, configuration);
    }

    private Optional<OrganizationalUnit> getOrganizationalUnit(String identifier, Collection<OrganizationalUnit> organizationalUnits) {
        return organizationalUnits.stream().filter(p -> p.getIdentifier().equalsIgnoreCase(identifier)).findFirst();
    }

    private String getPrimaryDefaultRepositoryName(OrganizationalUnit ou) {
        return this.getPreferences().getRepositoryPreferences().getName();
    }

    String getSecondaryDefaultRepositoryName(OrganizationalUnit ou) {
        String sanitizedOuIdentifier = ou.getIdentifier().replaceAll("[^A-Za-z0-9]", "-");
        String repositoryNameSuffix = this.getPreferences().getRepositoryPreferences().getName();
        String repositoryName = sanitizedOuIdentifier + "-" + repositoryNameSuffix;
        return repositoryName;
    }

    private RepositoryEnvironmentConfigurations getDefaultRepositoryEnvironmentConfigurations() {
        RepositoryEnvironmentConfigurations configuration = new RepositoryEnvironmentConfigurations();
        return configuration;
    }
}

