/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.project.utils.NewWorkspaceProjectUtils;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.Archetype;
import org.kie.workbench.common.screens.archetype.mgmt.shared.services.ArchetypeService;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.impl.IndexStatusOracle;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindAllLibraryAssetsQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueFileExtensionIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueFileNameIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueRepositoryRootIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.paging.PageResponse;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class LibraryServiceImpl
implements LibraryService {
    private static final Logger log = LoggerFactory.getLogger(LibraryServiceImpl.class);
    private static final String DEFAULT_PROJECT_NAME = "MyProject";
    private RefactoringQueryService refactoringQueryService;
    private OrganizationalUnitService ouService;
    private LibraryPreferences preferences;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private ExplorerServiceHelper explorerServiceHelper;
    private WorkspaceProjectService projectService;
    private KieModuleService moduleService;
    private ExamplesService examplesService;
    private IOService ioService;
    private UserManagerService userManagerService;
    private IndexStatusOracle indexOracle;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private ClusterService clusterService;
    private ArchetypeService archetypeService;

    public LibraryServiceImpl() {
    }

    @Inject
    public LibraryServiceImpl(OrganizationalUnitService ouService, RefactoringQueryService refactoringQueryService, LibraryPreferences preferences, AuthorizationManager authorizationManager, SessionInfo sessionInfo, ExplorerServiceHelper explorerServiceHelper, WorkspaceProjectService projectService, KieModuleService moduleService, ExamplesService examplesService, @Named(value="ioStrategy") IOService ioService, UserManagerService userManagerService, IndexStatusOracle indexOracle, SpaceConfigStorageRegistry spaceConfigStorageRegistry, ClusterService clusterService, ArchetypeService archetypeService) {
        this.ouService = ouService;
        this.refactoringQueryService = refactoringQueryService;
        this.preferences = preferences;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.explorerServiceHelper = explorerServiceHelper;
        this.projectService = projectService;
        this.moduleService = moduleService;
        this.examplesService = examplesService;
        this.ioService = ioService;
        this.userManagerService = userManagerService;
        this.indexOracle = indexOracle;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.clusterService = clusterService;
        this.archetypeService = archetypeService;
    }

    public OrganizationalUnitRepositoryInfo getDefaultOrganizationalUnitRepositoryInfo() {
        return this.getOrganizationalUnitRepositoryInfo(this.getDefaultOrganizationalUnit());
    }

    public OrganizationalUnitRepositoryInfo getOrganizationalUnitRepositoryInfo(OrganizationalUnit selectedOrganizationalUnit) {
        if (selectedOrganizationalUnit == null) {
            return null;
        }
        List<OrganizationalUnit> organizationalUnits = this.getOrganizationalUnits();
        OrganizationalUnit organizationalUnit = this.getOrganizationalUnit(selectedOrganizationalUnit.getIdentifier(), organizationalUnits).get();
        ArrayList repositories = new ArrayList(organizationalUnit.getRepositories());
        return new OrganizationalUnitRepositoryInfo(organizationalUnits, organizationalUnit, repositories);
    }

    public LibraryInfo getLibraryInfo(OrganizationalUnit organizationalUnit) {
        List projects = this.projectService.getAllWorkspaceProjects(organizationalUnit).stream().filter(p -> this.userCanReadProject((WorkspaceProject)p)).collect(Collectors.toList());
        return new LibraryInfo(projects);
    }

    private boolean userCanReadProject(WorkspaceProject project) {
        return this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.sessionInfo.getIdentity()) || project.getRepository().getContributors().stream().anyMatch(c -> c.getUsername().equals(this.sessionInfo.getIdentity().getIdentifier()));
    }

    public WorkspaceProject createProject(OrganizationalUnit organizationalUnit, String remoteRepositoryUrl, String repositoryAlias) {
        String projectName = repositoryAlias != null ? repositoryAlias : DEFAULT_PROJECT_NAME;
        Optional baseArchetype = this.archetypeService.getBaseKieArchetype();
        String baseArchetypeAlias = baseArchetype.map(Archetype::getAlias).orElse(null);
        GAV gav = this.createGAV(projectName, organizationalUnit);
        POM pom = this.createPOM(projectName, projectName, gav);
        return this.createProject(organizationalUnit, pom, DeploymentMode.VALIDATED, baseArchetypeAlias, remoteRepositoryUrl);
    }

    public WorkspaceProject createProject(String projectName, OrganizationalUnit selectedOrganizationalUnit, String projectDescription, DeploymentMode deploymentMode) {
        GAV gav = this.createGAV(projectName, selectedOrganizationalUnit);
        POM pom = this.createPOM(projectName, projectDescription, gav);
        return this.projectService.newProject(selectedOrganizationalUnit, pom, deploymentMode);
    }

    public WorkspaceProject createProject(OrganizationalUnit activeOrganizationalUnit, POM pom, DeploymentMode mode) {
        return this.createProject(activeOrganizationalUnit, pom, mode, null);
    }

    public WorkspaceProject createProject(OrganizationalUnit activeOrganizationalUnit, POM pom, DeploymentMode mode, String templateId) {
        return this.createProject(activeOrganizationalUnit, pom, mode, templateId, null);
    }

    public WorkspaceProject createProject(OrganizationalUnit activeOrganizationalUnit, POM pom, DeploymentMode mode, String templateId, String remoteRepositoryUrl) {
        return this.projectService.newProject(activeOrganizationalUnit, pom, mode, this.getRepositoryContributors(activeOrganizationalUnit), this.resolveTemplateRepository(templateId), remoteRepositoryUrl);
    }

    private List<Contributor> getRepositoryContributors(OrganizationalUnit organizationalUnit) {
        OrganizationalUnit ou = this.ouService.getOrganizationalUnit(organizationalUnit.getName());
        Collection spaceContributors = ou.getContributors();
        List<Contributor> contributors = spaceContributors.stream().filter(c -> !this.sessionInfo.getIdentity().getIdentifier().equals(c.getUsername())).collect(Collectors.toList());
        if (spaceContributors.size() == contributors.size()) {
            spaceContributors.add(new Contributor(this.sessionInfo.getIdentity().getIdentifier(), ContributorType.CONTRIBUTOR));
            this.ouService.updateOrganizationalUnit(ou.getName(), ou.getDefaultGroupId(), spaceContributors);
        }
        contributors.add(new Contributor(this.sessionInfo.getIdentity().getIdentifier(), ContributorType.OWNER));
        return contributors;
    }

    private Repository resolveTemplateRepository(String templateId) {
        if (templateId != null) {
            return this.archetypeService.getTemplateRepository(templateId);
        }
        return this.archetypeService.getBaseKieTemplateRepository().orElse(null);
    }

    public Boolean thereIsAProjectInTheWorkbench() {
        return !this.projectService.getAllWorkspaceProjects().isEmpty();
    }

    public AssetQueryResult getProjectAssets(ProjectAssetsQuery query) {
        PortablePreconditions.checkNotNull((String)"query", (Object)query);
        boolean projectStillExists = this.ioService.exists(Paths.convert((Path)query.getProject().getBranch().getPath()));
        if (!projectStillExists) {
            log.info("Asset lookup result: project [{}] does not exist.", (Object)LibraryServiceImpl.projectIdentifierFrom(query));
            return AssetQueryResult.nonexistent();
        }
        if (!this.indexOracle.isIndexed(query.getProject())) {
            log.info("Asset lookup result: project [{}] is not indexed.", (Object)LibraryServiceImpl.projectIdentifierFrom(query));
            return AssetQueryResult.unindexed();
        }
        HashSet<ValueIndexTerm> queryTerms = this.buildProjectAssetsQuery(query);
        PageResponse findRulesByProjectQuery = this.refactoringQueryService.query(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, query.getStartIndex(), Integer.valueOf(query.getAmount()), Boolean.TRUE));
        List assets = findRulesByProjectQuery.getPageRowList().stream().map(row -> {
            Path path = (Path)row.getValue();
            return new FolderItem((Object)path, path.getFileName(), FolderItemType.FILE, false, Paths.readLockedBy((Path)path), Collections.emptyList(), this.explorerServiceHelper.getRestrictedOperations(path));
        }).collect(Collectors.toList());
        log.info("Asset lookup result: project [{}] is indexed with {} index hits.", (Object)LibraryServiceImpl.projectIdentifierFrom(query), (Object)assets.size());
        return AssetQueryResult.normal(assets.stream().map(asset -> {
            AssetInfo info = null;
            try {
                Map attributes = this.ioService.readAttributes(Paths.convert((Path)((Path)asset.getItem())));
                FileTime lastModifiedFileTime = (FileTime)this.getAttribute("lastModifiedTime", attributes).get();
                FileTime createdFileTime = (FileTime)this.getAttribute("creationTime", attributes).get();
                Date lastModifiedTime = new Date(lastModifiedFileTime.toMillis());
                Date createdTime = new Date(createdFileTime.toMillis());
                info = new AssetInfo(asset, lastModifiedTime, createdTime);
            }
            catch (NoSuchFileException nfe) {
                log.debug("File '" + asset.getFileName() + "' in LibraryIndex but not VFS. Suspected deletion. Skipping.");
            }
            return Optional.ofNullable(info);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    private static String projectIdentifierFrom(ProjectAssetsQuery query) {
        return Optional.ofNullable(query.getProject().getRepository()).map(repo -> repo.getIdentifier()).orElseGet(() -> query.getProject().getName());
    }

    private HashSet<ValueIndexTerm> buildProjectAssetsQuery(ProjectAssetsQuery query) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add((ValueIndexTerm)new LibraryValueRepositoryRootIndexTerm(query.getProject().getRootPath().toURI()));
        if (query.hasFilter()) {
            queryTerms.add((ValueIndexTerm)new LibraryValueFileNameIndexTerm("*" + query.getFilter() + "*", ValueIndexTerm.TermSearchType.WILDCARD));
        }
        if (query.hasExtension()) {
            queryTerms.add((ValueIndexTerm)new LibraryValueFileExtensionIndexTerm(query.getExtensions()));
        }
        return queryTerms;
    }

    public Boolean hasProjects(OrganizationalUnit organizationalUnit) {
        return !this.projectService.getAllWorkspaceProjects(organizationalUnit).isEmpty();
    }

    public Boolean hasAssets(WorkspaceProject project) {
        PortablePreconditions.checkNotNull((String)"LibraryServiceImpl.project", (Object)project);
        boolean projectStillExists = this.ioService.exists(Paths.convert((Path)project.getRootPath()));
        if (!projectStillExists) {
            return false;
        }
        Package defaultPackage = this.moduleService.resolveDefaultPackage(project.getMainModule());
        return this.explorerServiceHelper.hasAssets(defaultPackage);
    }

    public Set<ImportProject> getExampleProjects(OrganizationalUnit organizationalUnit) {
        String importProjectsUrl = this.getCustomImportProjectsUrl();
        ExampleRepository repository = importProjectsUrl == null || importProjectsUrl.isEmpty() ? this.examplesService.getPlaygroundRepository() : new ExampleRepository(importProjectsUrl);
        Set projects = this.examplesService.getProjects(organizationalUnit, repository);
        return projects;
    }

    public List<OrganizationalUnit> getOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.ouService.getOrganizationalUnits());
    }

    public GAV createGAV(String projectName, OrganizationalUnit selectedOrganizationalUnit) {
        LibraryPreferences preferences = this.getPreferences();
        String artifactId = NewWorkspaceProjectUtils.sanitizeProjectName((String)projectName);
        return new GAV(selectedOrganizationalUnit.getDefaultGroupId(), artifactId, preferences.getProjectPreferences().getVersion());
    }

    public synchronized List<String> getAllUsers() {
        try {
            List users = this.userManagerService.search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, Integer.MAX_VALUE)).getResults();
            return users.stream().map(User::getIdentifier).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Error while searching all users: " + e.getClass().getCanonicalName());
            return Collections.emptyList();
        }
    }

    public void addBranch(String newBranchName, String baseBranchName, WorkspaceProject project) {
        this.projectService.addBranch(newBranchName, baseBranchName, project, this.sessionInfo.getIdentity().getIdentifier());
    }

    public void removeBranch(WorkspaceProject project, Branch branch) {
        this.projectService.removeBranch(branch.getName(), project, this.sessionInfo.getIdentity().getIdentifier());
    }

    public BranchPermissions loadBranchPermissions(String spaceName, String projectIdentifier, String branchName) {
        return this.spaceConfigStorageRegistry.get(spaceName).loadBranchPermissions(branchName, projectIdentifier);
    }

    public void saveBranchPermissions(String spaceName, String projectIdentifier, String branchName, BranchPermissions branchPermissions) {
        this.spaceConfigStorageRegistry.get(spaceName).saveBranchPermissions(branchName, projectIdentifier, branchPermissions);
    }

    public Boolean isClustered() {
        return this.clusterService.isAppFormerClustered();
    }

    String getCustomImportProjectsUrl() {
        return System.getProperty("org.kie.project.examples.repository.url");
    }

    LibraryPreferences getPreferences() {
        this.preferences.load();
        return this.preferences;
    }

    POM createPOM(String projectName, String projectDescription, GAV gav) {
        return new POM(projectName, projectDescription, "", gav);
    }

    private Optional<Object> getAttribute(String attribute, Map<String, Object> attributes) {
        return attributes.entrySet().stream().filter(entry -> attribute.equals(entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    public int getNumberOfAssets(ProjectAssetsQuery query) {
        HashSet<ValueIndexTerm> queryTerms = this.buildProjectAssetsQuery(query);
        return this.refactoringQueryService.queryHitCount(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, 0, null));
    }

    public int getNumberOfAssets(WorkspaceProject module) {
        HashSet<LibraryValueRepositoryRootIndexTerm> queryTerms = new HashSet<LibraryValueRepositoryRootIndexTerm>();
        queryTerms.add(new LibraryValueRepositoryRootIndexTerm(module.getRootPath().toURI()));
        return this.refactoringQueryService.queryHitCount(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, 0, null, Boolean.TRUE));
    }

    public OrganizationalUnit getDefaultOrganizationalUnit() {
        List<OrganizationalUnit> organizationalUnits;
        String defaultOUIdentifier = this.getPreferences().getOrganizationalUnitPreferences().getName();
        Optional<OrganizationalUnit> defaultOU = this.getOrganizationalUnit(defaultOUIdentifier, organizationalUnits = this.getOrganizationalUnits());
        if (defaultOU.isPresent()) {
            return defaultOU.get();
        }
        if (!organizationalUnits.isEmpty()) {
            return organizationalUnits.get(0);
        }
        return this.createDefaultOrganizationalUnit();
    }

    private OrganizationalUnit createDefaultOrganizationalUnit() {
        if (!this.authorizationManager.authorize((ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)OrganizationalUnitAction.CREATE, this.sessionInfo.getIdentity())) {
            throw new UnauthorizedException("User :user has no permissions to :type -> :action".replace(":user", this.sessionInfo.getIdentity().getIdentifier()).replace(":type", OrganizationalUnit.RESOURCE_TYPE.getName()).replace(":action", OrganizationalUnitAction.CREATE.getName()));
        }
        LibraryPreferences preferences = this.getPreferences();
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        contributors.add(new Contributor(preferences.getOrganizationalUnitPreferences().getOwner(), ContributorType.OWNER));
        return this.ouService.createOrganizationalUnit(preferences.getOrganizationalUnitPreferences().getName(), preferences.getOrganizationalUnitPreferences().getGroupId(), Collections.emptyList(), contributors);
    }

    private Optional<OrganizationalUnit> getOrganizationalUnit(String identifier, Collection<OrganizationalUnit> organizationalUnits) {
        return organizationalUnits.stream().filter(p -> p.getIdentifier().equalsIgnoreCase(identifier)).findFirst();
    }
}

